/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.util.List;
import java.util.Map;
import org.zalando.flatjson.Json;
import org.zalando.flatjson.JsonList;
import org.zalando.flatjson.JsonMap;
import org.zalando.flatjson.Overlay;
import org.zalando.flatjson.Visitor;

class Parsed
extends Json {
    protected final Overlay overlay;
    protected final int element;

    Parsed(Overlay overlay, int element) {
        this.overlay = overlay;
        this.element = element;
    }

    @Override
    public void accept(Visitor visitor) {
        this.overlay.accept(this.element, visitor);
    }

    public String toString() {
        return this.overlay.getJson(this.element);
    }

    static class Object
    extends Parsed {
        private Map<String, Json> map;

        Object(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map<String, Json> asObject() {
            if (this.map == null) {
                this.map = this.createMap();
            }
            return this.map;
        }

        @Override
        public String toString() {
            return this.map == null ? super.toString() : this.map.toString();
        }

        private Map<String, Json> createMap() {
            JsonMap<String, Json> result = new JsonMap<String, Json>();
            for (int e = this.element + 1; e <= this.element + this.overlay.getNested(this.element); e += this.overlay.getNested(e + 1) + 2) {
                String key = this.overlay.getUnescapedString(e);
                result.put(key, Object.create(this.overlay, e + 1));
            }
            return result;
        }
    }

    static class Array
    extends Parsed {
        private List<Json> array;

        Array(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public List<Json> asArray() {
            if (this.array == null) {
                this.array = this.createArray();
            }
            return this.array;
        }

        @Override
        public String toString() {
            return this.array == null ? super.toString() : this.array.toString();
        }

        private List<Json> createArray() {
            JsonList<Json> result = new JsonList<Json>();
            for (int e = this.element + 1; e <= this.element + this.overlay.getNested(this.element); e += this.overlay.getNested(e) + 1) {
                result.add(Array.create(this.overlay, e));
            }
            return result;
        }
    }

    static class Strng
    extends Parsed {
        private String string;

        Strng(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String asString() {
            if (this.string == null) {
                this.string = this.overlay.getUnescapedString(this.element);
            }
            return this.string;
        }
    }
}

