/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

class StringCodec {
    StringCodec() {
    }

    static String escape(String input) {
        StringBuilder result = new StringBuilder(input.length());
        block9: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        result.append("\\u" + Integer.toUnsignedString(c, 16));
                        continue block9;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    static String unescape(String input) {
        StringBuilder result = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\\') {
                switch (input.charAt(++i)) {
                    case '\\': {
                        result.append('\\');
                        break;
                    }
                    case '/': {
                        result.append('/');
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        break;
                    }
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'u': {
                        result.append(Character.toChars(Integer.parseInt(input.substring(i + 1, i + 5), 16)));
                        i += 4;
                    }
                }
                continue;
            }
            result.append(input.charAt(i));
        }
        return result.toString();
    }
}

