/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.util.ArrayList;
import java.util.List;
import org.zalando.flatjson.Json;
import org.zalando.flatjson.ParseException;
import org.zalando.flatjson.StringCodec;
import org.zalando.flatjson.Visitor;

class Overlay {
    private static final int TYPE = 0;
    private static final int FROM = 1;
    private static final int TO = 2;
    private static final int NESTED = 3;
    private final String raw;
    private final List<int[]> blocks;
    private final int blockSize;
    private int element;

    static int calculateBlockSize(int rawChars) {
        return 4 * Math.min(Math.max(rawChars / 16, 4), 1024);
    }

    Overlay(String raw) {
        if (raw == null) {
            throw new ParseException("cannot parse null");
        }
        this.raw = raw;
        this.blocks = new ArrayList<int[]>();
        this.blockSize = Overlay.calculateBlockSize(raw.length());
        this.element = 0;
        this.parse();
    }

    Json.Type getType(int element) {
        return Json.Type.values()[this.getComponent(element, 0)];
    }

    int getNested(int element) {
        return this.getComponent(element, 3);
    }

    String getJson(int element) {
        return this.raw.substring(this.getComponent(element, 1), this.getComponent(element, 2) + 1);
    }

    String getUnescapedString(int element) {
        String value = this.raw.substring(this.getComponent(element, 1) + 1, this.getComponent(element, 2));
        return this.getType(element) == Json.Type.STRING_ESCAPED ? StringCodec.unescape(value) : value;
    }

    void accept(int element, Visitor visitor) {
        Json.Type type = this.getType(element);
        switch (type) {
            case NULL: {
                visitor.visitNull();
                break;
            }
            case TRUE: {
                visitor.visitBoolean(true);
                break;
            }
            case FALSE: {
                visitor.visitBoolean(false);
                break;
            }
            case NUMBER: {
                visitor.visitNumber(this.getJson(element));
                break;
            }
            case STRING_ESCAPED: 
            case STRING: {
                visitor.visitString(this.getUnescapedString(element));
                break;
            }
            case ARRAY: {
                this.acceptArray(element, visitor);
                break;
            }
            case OBJECT: {
                this.acceptObject(element, visitor);
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + (Object)((Object)type));
            }
        }
    }

    private void acceptArray(int element, Visitor visitor) {
        visitor.beginArray();
        for (int e = element + 1; e <= element + this.getNested(element); e += this.getNested(e) + 1) {
            this.accept(e, visitor);
        }
        visitor.endArray();
    }

    private void acceptObject(int element, Visitor visitor) {
        visitor.beginObject();
        for (int e = element + 1; e <= element + this.getNested(element); e += this.getNested(e + 1) + 2) {
            String key = this.getUnescapedString(e);
            visitor.visitString(key);
            this.accept(e + 1, visitor);
        }
        visitor.endObject();
    }

    private void parse() {
        try {
            int last = this.skipWhitespace(this.parseValue(0));
            if (last != this.raw.length()) {
                throw new ParseException("malformed json");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("unbalanced json");
        }
    }

    private int parseValue(int i) {
        i = this.skipWhitespace(i);
        switch (this.raw.charAt(i)) {
            case '\"': {
                return this.parseString(i);
            }
            case '{': {
                return this.parseObject(i);
            }
            case '[': {
                return this.parseArray(i);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumber(i);
            }
            case 't': {
                return this.parseTrue(i);
            }
            case 'f': {
                return this.parseFalse(i);
            }
            case 'n': {
                return this.parseNull(i);
            }
        }
        throw new ParseException("illegal char at pos: " + i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseNumber(int i) {
        int from = i;
        boolean minus = false;
        boolean leadingZero = false;
        boolean dot = false;
        boolean exponent = false;
        while (i < this.raw.length()) {
            char c = this.raw.charAt(i);
            if (c == '-') {
                if (i > from) {
                    throw new ParseException("minus inside number");
                }
                minus = true;
            } else if (c == 'e' || c == 'E') {
                if (exponent) {
                    throw new ParseException("double exponents");
                }
                leadingZero = false;
                exponent = true;
                c = this.raw.charAt(i + 1);
                if (c == '-' || c == '+') {
                    c = this.raw.charAt(i + 2);
                    if (c < '0' || c > '9') {
                        throw new ParseException("invalid exponent");
                    }
                    i += 2;
                } else {
                    if (c < '0' || c > '9') throw new ParseException("invalid exponent");
                    ++i;
                }
            } else if (c == '.') {
                if (dot) {
                    throw new ParseException("multiple dots");
                }
                if (i == from || minus && i == from + 1) {
                    throw new ParseException("no digit before dot");
                }
                leadingZero = false;
                dot = true;
            } else if (c == '0') {
                if (i == from) {
                    leadingZero = true;
                }
            } else {
                if (c < '1' || c > '9') break;
                if (leadingZero) {
                    throw new ParseException("leading zero");
                }
            }
            ++i;
        }
        if (!minus || from != i - 1) return this.createElement(Json.Type.NUMBER, from, i - 1, 0);
        throw new ParseException("isolated minus");
    }

    private int parseString(int i) {
        boolean escaped = false;
        int from = i++;
        while (true) {
            char c;
            if ((c = this.raw.charAt(i)) == '\"') {
                Json.Type type = escaped ? Json.Type.STRING_ESCAPED : Json.Type.STRING;
                return this.createElement(type, from, i, 0);
            }
            if (c < ' ') {
                throw new ParseException("illegal control char: " + c);
            }
            if (c == '\\') {
                escaped = true;
                c = this.raw.charAt(i + 1);
                if (c == '\"' || c == '/' || c == '\\' || c == 'b' || c == 'f' || c == 'n' || c == 'r' || c == 't') {
                    ++i;
                } else if (c == 'u') {
                    this.expectHex(i + 2);
                    this.expectHex(i + 3);
                    this.expectHex(i + 4);
                    this.expectHex(i + 5);
                    i += 5;
                } else {
                    throw new ParseException("illegal escape char: " + c);
                }
            }
            ++i;
        }
    }

    private int parseArray(int i) {
        int count = 0;
        int e = this.element;
        this.createElement(Json.Type.ARRAY, i);
        ++i;
        while (this.raw.charAt(i = this.skipWhitespace(i)) != ']') {
            if (count > 0) {
                this.expectChar(i, ',');
                i = this.skipWhitespace(i + 1);
            }
            i = this.parseValue(i);
            ++count;
        }
        return this.closeElement(e, i, this.element - e - 1);
    }

    private int parseObject(int i) {
        int count = 0;
        int e = this.element;
        this.createElement(Json.Type.OBJECT, i);
        ++i;
        while (this.raw.charAt(i = this.skipWhitespace(i)) != '}') {
            if (count > 0) {
                this.expectChar(i, ',');
                i = this.skipWhitespace(i + 1);
            }
            this.expectChar(i, '\"');
            i = this.parseString(i);
            i = this.skipWhitespace(i);
            this.expectChar(i, ':');
            i = this.skipWhitespace(i + 1);
            i = this.parseValue(i);
            ++count;
        }
        return this.closeElement(e, i, this.element - e - 1);
    }

    private int parseNull(int i) {
        this.expectChar(i + 1, 'u');
        this.expectChar(i + 2, 'l');
        this.expectChar(i + 3, 'l');
        return this.createElement(Json.Type.NULL, i, i + 3, 0);
    }

    private int parseTrue(int i) {
        this.expectChar(i + 1, 'r');
        this.expectChar(i + 2, 'u');
        this.expectChar(i + 3, 'e');
        return this.createElement(Json.Type.TRUE, i, i + 3, 0);
    }

    private int parseFalse(int i) {
        this.expectChar(i + 1, 'a');
        this.expectChar(i + 2, 'l');
        this.expectChar(i + 3, 's');
        this.expectChar(i + 4, 'e');
        return this.createElement(Json.Type.FALSE, i, i + 4, 0);
    }

    private int skipWhitespace(int i) {
        char c;
        while (i < this.raw.length() && ((c = this.raw.charAt(i)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            ++i;
        }
        return i;
    }

    private void expectChar(int i, char c) {
        if (this.raw.charAt(i) != c) {
            throw new ParseException("expected char '" + c + "' at pos " + i);
        }
    }

    private void expectHex(int i) {
        char c = this.raw.charAt(i);
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            return;
        }
        throw new ParseException("invalid hex char at pos " + i);
    }

    private int getComponent(int element, int offset) {
        return this.getBlock(element)[this.getBlockIndex(element) + offset];
    }

    private int createElement(Json.Type type, int from) {
        return this.createElement(type, from, -1, -1);
    }

    private int createElement(Json.Type type, int from, int to, int nested) {
        int currentBlock = this.element * 4 / this.blockSize;
        if (currentBlock == this.blocks.size()) {
            this.blocks.add(new int[this.blockSize]);
        }
        int[] block = this.blocks.get(currentBlock);
        int index = this.getBlockIndex(this.element);
        block[index] = type.ordinal();
        block[index + 1] = from;
        block[index + 2] = to;
        block[index + 3] = nested;
        ++this.element;
        return to + 1;
    }

    private int closeElement(int element, int to, int nested) {
        int[] block = this.getBlock(element);
        int index = this.getBlockIndex(element);
        block[index + 2] = to;
        block[index + 3] = nested;
        return to + 1;
    }

    private int[] getBlock(int element) {
        return this.blocks.get(element * 4 / this.blockSize);
    }

    private int getBlockIndex(int element) {
        return element * 4 % this.blockSize;
    }
}

