/**
 * Copyright (C) 2015 Zalando SE (http://tech.zalando.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zalando.github;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;

@Data
public class StatusRequest {

	private String state;

	@JsonProperty("target_url")
	private String targetUrl;

	private String description;

	private String context = "default";

	protected StatusRequest(String state) {
		this.state = state;
	}

	public static StatusRequest pendingStatusRequest() {
		return new StatusRequest("pending");
	}

	public static StatusRequest successStatusRequest() {
		return new StatusRequest("success");
	}

	public static StatusRequest errorStatusRequest() {
		return new StatusRequest("error");
	}

	public static StatusRequest failureStatusRequest() {
		return new StatusRequest("failure");
	}
}
