/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;
import org.zalando.github.Issue;
import org.zalando.github.IssueRequest;
import org.zalando.github.IssuesOperations;

public class IssuesTemplate
implements IssuesOperations {
    private RestTemplate restTemplate;

    public IssuesTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public List<Issue> listAllIssues() {
        return new ArrayList<Issue>(0);
    }

    public List<Issue> listUserIssues() {
        return new ArrayList<Issue>(0);
    }

    public List<Issue> listOrganizationIssues(String organization) {
        return new ArrayList<Issue>(0);
    }

    public Issue createIssue(IssueRequest issueRequest, String owner, String repo) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("owner", owner);
        uriVariables.put("repo", repo);
        URI uri = new UriTemplate(this.buildUriString("/repos/{owner}/{repo}/issues")).expand(uriVariables);
        RequestEntity entity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)issueRequest);
        ResponseEntity responseEntity = this.getRestTemplate().exchange(entity, Issue.class);
        return (Issue)responseEntity.getBody();
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected UriTemplate buildUriTemplate(String path) {
        return new UriTemplate(this.buildUriString(path));
    }

    protected String buildUriString(String path) {
        return "https://api.github.com" + path;
    }
}

