/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriTemplate;

public abstract class AbstractGithubTemplate {
    private RestOperations restOperations;

    public AbstractGithubTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    protected UriTemplate buildUriTemplate(String path) {
        return new UriTemplate(this.buildUriString(path));
    }

    protected URI buildUri(String path, Map<String, Object> uriVariables) {
        return new UriTemplate(this.buildUriString(path)).expand(uriVariables);
    }

    protected URI buildUri(String path) {
        return this.buildUri(path, new HashMap<String, Object>(0));
    }

    protected String buildUriString(String path) {
        return "https://api.github.com" + path;
    }
}

