/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestOperations;
import org.zalando.github.ExtOrganization;
import org.zalando.github.Organization;
import org.zalando.github.OrganizationUpdate;
import org.zalando.github.OrganizationsOperations;
import org.zalando.github.spring.AbstractGithubTemplate;

public class OrganizationsTemplate
extends AbstractGithubTemplate
implements OrganizationsOperations {
    private final ParameterizedTypeReference<List<Organization>> orgaListTypeRef = new ParameterizedTypeReference<List<Organization>>(){};

    public OrganizationsTemplate(RestOperations restOperations) {
        super(restOperations);
    }

    public List<Organization> listAllOranizations() {
        return this.listOrganizations("/organizations");
    }

    public List<Organization> listOrganizations() {
        return this.listOrganizations("/user/orgs");
    }

    public List<Organization> listUserOrganizations(String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("username", username);
        return this.listOrganizations("/user/{username}/orgs", uriVariables);
    }

    protected List<Organization> listOrganizations(String path) {
        return this.listOrganizations(path, Collections.emptyMap());
    }

    protected List<Organization> listOrganizations(String path, Map<String, Object> uriVariables) {
        return (List)this.getRestOperations().exchange(this.buildUri(path, uriVariables), HttpMethod.GET, null, this.orgaListTypeRef).getBody();
    }

    public ExtOrganization getOrganization(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return (ExtOrganization)this.getRestOperations().getForObject(this.buildUri("/orgs/{organization}", uriVariables), ExtOrganization.class);
    }

    public ExtOrganization updateOrganization(OrganizationUpdate update, String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        RequestEntity entity = RequestEntity.patch((URI)this.buildUri("/orgs/{organization}", uriVariables)).contentType(MediaType.APPLICATION_JSON).body((Object)update);
        return (ExtOrganization)this.getRestOperations().exchange(entity, ExtOrganization.class).getBody();
    }
}

