/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestOperations;
import org.zalando.github.Email;
import org.zalando.github.ExtPubKey;
import org.zalando.github.PubKey;
import org.zalando.github.PubKeyInput;
import org.zalando.github.UsersOperations;
import org.zalando.github.spring.AbstractGithubTemplate;

public class UsersTemplate
extends AbstractGithubTemplate
implements UsersOperations {
    public static final String USER_EMAILS_PATH = "/user/emails";
    private final ParameterizedTypeReference<List<Email>> emailListTypeRef = new ParameterizedTypeReference<List<Email>>(){};
    private final ParameterizedTypeReference<List<ExtPubKey>> extPubKeyListTypeRef = new ParameterizedTypeReference<List<ExtPubKey>>(){};
    private final ParameterizedTypeReference<List<PubKey>> pubKeyListTypeRef = new ParameterizedTypeReference<List<PubKey>>(){};

    public UsersTemplate(RestOperations restOperations) {
        super(restOperations);
    }

    public List<Email> listEmails() {
        return Arrays.asList((Object[])this.getRestOperations().getForEntity(this.buildUriString(USER_EMAILS_PATH), Email[].class, new Object[0]).getBody());
    }

    public List<Email> addEmails(String ... emails) {
        return this.addEmails(Arrays.asList(emails));
    }

    public List<Email> addEmails(List<String> emails) {
        RequestEntity reqEntity = RequestEntity.post((URI)this.buildUri(USER_EMAILS_PATH)).contentType(MediaType.APPLICATION_JSON).body(emails);
        return (List)this.getRestOperations().exchange(reqEntity, this.emailListTypeRef).getBody();
    }

    public void deleteEmails(String ... emails) {
        this.deleteEmails(Arrays.asList(emails));
    }

    public void deleteEmails(List<String> emails) {
        RequestEntity reqEntity = RequestEntity.method((HttpMethod)HttpMethod.DELETE, (URI)this.buildUri(USER_EMAILS_PATH)).contentType(MediaType.APPLICATION_JSON).body(emails);
        this.getRestOperations().exchange(reqEntity, Void.class);
    }

    public List<PubKey> listPublicKeys(String username) {
        HashMap<String, Object> uriVariabels = new HashMap<String, Object>(0);
        uriVariabels.put("username", username);
        RequestEntity reqEntity = RequestEntity.get((URI)this.buildUri("/users/{username}/keys", uriVariabels)).build();
        return (List)this.getRestOperations().exchange(reqEntity, this.pubKeyListTypeRef).getBody();
    }

    public List<ExtPubKey> listPublicKeys() {
        return (List)this.getRestOperations().exchange(this.buildUri("/user/keys"), HttpMethod.GET, null, this.extPubKeyListTypeRef).getBody();
    }

    public ExtPubKey getPublicKey(long id) {
        HashMap<String, Object> uriVariabels = new HashMap<String, Object>(0);
        uriVariabels.put("id", id);
        return (ExtPubKey)this.getRestOperations().getForObject(this.buildUri("/user/keys/{id}", uriVariabels), ExtPubKey.class);
    }

    public ExtPubKey createPublicKey(PubKeyInput pubKey) {
        RequestEntity reqEntity = RequestEntity.post((URI)this.buildUri(USER_EMAILS_PATH)).contentType(MediaType.APPLICATION_JSON).body((Object)pubKey);
        return (ExtPubKey)this.getRestOperations().exchange(reqEntity, ExtPubKey.class).getBody();
    }

    public void deletePublicKey(long id) {
        HashMap<String, Object> uriVariabels = new HashMap<String, Object>(0);
        uriVariabels.put("id", id);
        this.getRestOperations().delete(this.buildUri("/user/keys/{id}", uriVariabels));
    }
}

