/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriTemplate;
import org.zalando.github.spring.GithubApiUriUtil;

public abstract class AbstractGithubTemplate {
    private final RestOperations restOperations;
    private final GithubApiUriUtil uriUtil;

    public AbstractGithubTemplate(RestOperations restOperations) {
        this(restOperations, new GithubApiUriUtil());
    }

    public AbstractGithubTemplate(RestOperations restOperations, GithubApiUriUtil uriUtil) {
        this.restOperations = restOperations;
        this.uriUtil = uriUtil;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public RestOperations getRestOperations(ResponseErrorHandler responseErrorHandler) {
        return this.restOperations;
    }

    protected UriTemplate buildUriTemplate(String path) {
        return this.uriUtil.buildUriTemplate(path);
    }

    protected URI buildUri(String path, Map<String, Object> uriVariables) {
        return this.uriUtil.buildUri(path, uriVariables);
    }

    protected URI buildUri(String path) {
        return this.uriUtil.buildUri(path, new HashMap<String, Object>(0));
    }

    protected String buildUriString(String path) {
        return this.uriUtil.buildUriString(path);
    }
}

