/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestOperations;
import org.zalando.github.Team;
import org.zalando.github.TeamRequest;
import org.zalando.github.TeamsOperations;
import org.zalando.github.spring.AbstractGithubTemplate;
import org.zalando.github.spring.GithubApiUriUtil;
import org.zalando.github.spring.pagination.PagingIterator;

public class TeamsTemplate
extends AbstractGithubTemplate
implements TeamsOperations {
    private final ParameterizedTypeReference<List<Team>> teamListTypeRef = new ParameterizedTypeReference<List<Team>>(){};

    public TeamsTemplate(RestOperations restOperations, GithubApiUriUtil uriUtil) {
        super(restOperations, uriUtil);
    }

    public TeamsTemplate(RestOperations restOperations) {
        super(restOperations);
    }

    public List<Team> listTeams(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        ArrayList<Team> teamList = new ArrayList<Team>();
        PagingIterator<List<Team>> iter = new PagingIterator<List<Team>>(this.getRestOperations(), this.buildUri("/orgs/{organization}/teams?per_page=25", uriVariables), this.teamListTypeRef);
        while (iter.hasNext()) {
            teamList.addAll((Collection)iter.next());
        }
        return teamList;
    }

    public Team getTeam(long teamId) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamid", teamId);
        return (Team)this.getRestOperations().getForObject(this.buildUri("/teams/{teamid}", uriVariables), Team.class);
    }

    public Team createTeam(String organization, TeamRequest teamRequest) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        RequestEntity entity = RequestEntity.post((URI)this.buildUri("/orgs/{organization}/teams", uriVariables)).contentType(MediaType.APPLICATION_JSON).body((Object)teamRequest);
        return (Team)this.getRestOperations().exchange(entity, Team.class).getBody();
    }

    public Team updateTeam(long teamId, TeamRequest teamRequest) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamid", teamId);
        RequestEntity entity = RequestEntity.patch((URI)this.buildUri("/teams/{teamid}", uriVariables)).contentType(MediaType.APPLICATION_JSON).body((Object)teamRequest);
        return (Team)this.getRestOperations().exchange(entity, Team.class).getBody();
    }

    public void deleteTeam(long teamId) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("teamid", teamId);
        this.getRestOperations().delete(this.buildUri("/teams/{teamid}", uriVariables));
    }
}

