/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriTemplate;
import org.zalando.github.Issue;
import org.zalando.github.IssueRequest;
import org.zalando.github.IssuesOperations;
import org.zalando.github.spring.AbstractGithubTemplate;
import org.zalando.github.spring.GithubApiUriUtil;

public class IssuesTemplate
extends AbstractGithubTemplate
implements IssuesOperations {
    private final ParameterizedTypeReference<List<Issue>> issueListTypeRef = new ParameterizedTypeReference<List<Issue>>(){};

    public IssuesTemplate(RestOperations restOperations) {
        super(restOperations);
    }

    public IssuesTemplate(RestOperations restOperations, GithubApiUriUtil githubApiUriUtil) {
        super(restOperations, githubApiUriUtil);
    }

    public List<Issue> listAllIssues() {
        return (List)this.getRestOperations().exchange(this.buildUri("/issues?per_page=25"), HttpMethod.GET, null, this.issueListTypeRef).getBody();
    }

    public List<Issue> listUserIssues() {
        return (List)this.getRestOperations().exchange(this.buildUri("/user/issues?per_page=25"), HttpMethod.GET, null, this.issueListTypeRef).getBody();
    }

    public List<Issue> listOrganizationIssues(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return (List)this.getRestOperations().exchange(this.buildUri("/orgs/{organization}/issues?per_page=25", uriVariables), HttpMethod.GET, null, this.issueListTypeRef).getBody();
    }

    public Issue createIssue(IssueRequest issueRequest, String owner, String repo) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("owner", owner);
        uriVariables.put("repo", repo);
        URI uri = new UriTemplate(this.buildUriString("/repos/{owner}/{repo}/issues")).expand(uriVariables);
        RequestEntity entity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)issueRequest);
        ResponseEntity responseEntity = this.getRestOperations().exchange(entity, Issue.class);
        return (Issue)responseEntity.getBody();
    }
}

