/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;
import org.zalando.github.MembersOperations;
import org.zalando.github.User;
import org.zalando.github.spring.AbstractGithubTemplate;
import org.zalando.github.spring.GithubApiUriUtil;
import org.zalando.github.spring.pagination.PagingIterator;

public class MembersTemplate
extends AbstractGithubTemplate
implements MembersOperations {
    private final ParameterizedTypeReference<List<User>> userListTypeRef = new ParameterizedTypeReference<List<User>>(){};

    public MembersTemplate(RestOperations restOperations, GithubApiUriUtil uriUtil) {
        super(restOperations, uriUtil);
    }

    public MembersTemplate(RestOperations restOperations) {
        super(restOperations);
    }

    public List<User> listMembers(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return this.fetchUsers("/orgs/{organization}/members?per_page=25", uriVariables);
    }

    public List<User> listPublicMembers(String organization) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        return this.fetchUsers("/orgs/{organization}/public_members?per_page=25", uriVariables);
    }

    protected List<User> fetchUsers(String path, Map<String, Object> uriVariables) {
        ArrayList<User> usersList = new ArrayList<User>();
        PagingIterator<List<User>> iter = new PagingIterator<List<User>>(this.getRestOperations(), this.buildUri(path, uriVariables), this.userListTypeRef);
        while (iter.hasNext()) {
            usersList.addAll((Collection)iter.next());
        }
        return usersList;
    }

    public boolean isMemberOfOrganization(String organization, String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        uriVariables.put("username", username);
        HttpStatus status = HttpStatus.NOT_FOUND;
        try {
            ResponseEntity responseEntity = this.getRestOperations().getForEntity(this.buildUri("/orgs/{organization}/members/{username}", uriVariables), Void.class);
            status = responseEntity.getStatusCode();
        }
        catch (HttpClientErrorException httpClientErrorException) {
            // empty catch block
        }
        return HttpStatus.NO_CONTENT.equals((Object)status);
    }

    public boolean isPublicMemberOfOrganization(String organization, String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        uriVariables.put("username", username);
        HttpStatus status = HttpStatus.NOT_FOUND;
        try {
            ResponseEntity responseEntity = this.getRestOperations().getForEntity(this.buildUri("/orgs/{organization}/public_members/{username}", uriVariables), Void.class);
            status = responseEntity.getStatusCode();
        }
        catch (HttpClientErrorException httpClientErrorException) {
            // empty catch block
        }
        return HttpStatus.NO_CONTENT.equals((Object)status);
    }

    public void removeFromOrganization(String organization, String username) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("organization", organization);
        uriVariables.put("username", username);
        this.getRestOperations().delete(this.buildUri("/orgs/{organization}/members/{username}", uriVariables));
    }
}

