/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.github.spring;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriTemplate;
import org.zalando.github.CombinedStatus;
import org.zalando.github.Status;
import org.zalando.github.StatusRequest;
import org.zalando.github.StatusesOperations;
import org.zalando.github.spring.AbstractGithubTemplate;

public class StatusesTemplate
extends AbstractGithubTemplate
implements StatusesOperations {
    private final ParameterizedTypeReference<List<Status>> statusListTypeRef = new ParameterizedTypeReference<List<Status>>(){};

    public StatusesTemplate(RestOperations restOperations) {
        super(restOperations);
    }

    public Status createStatus(String owner, String repository, String sha, StatusRequest body) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("owner", owner);
        uriVariables.put("repository", repository);
        uriVariables.put("sha", sha);
        URI uri = new UriTemplate(this.buildUriString("/repos/{owner}/{repository}/statuses/{sha}")).expand(uriVariables);
        RequestEntity entity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)body);
        ResponseEntity responseEntity = this.getRestOperations().exchange(entity, Status.class);
        return (Status)responseEntity.getBody();
    }

    public List<Status> listStatuses(String owner, String repository, String ref) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("owner", owner);
        uriVariables.put("repository", repository);
        uriVariables.put("ref", ref);
        return (List)this.getRestOperations().exchange(this.buildUri("/repos/{owner}/{repository}/commits/{ref}/statuses", uriVariables), HttpMethod.GET, null, this.statusListTypeRef).getBody();
    }

    public CombinedStatus getCombinedStatus(String owner, String repository, String ref) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("owner", owner);
        uriVariables.put("repository", repository);
        uriVariables.put("ref", ref);
        return (CombinedStatus)this.getRestOperations().exchange(this.buildUri("/repos/{owner}/{repository}/commits/{ref}/status", uriVariables), HttpMethod.GET, null, CombinedStatus.class).getBody();
    }
}

