package org.zalando.grafter.macros

object ReadersCMacroTest {
  trait ConfigType
  trait Prod extends ConfigType
  trait Dev  extends ConfigType

  @readers
  case class Config[CT](
    host: (String, CT),
    port: (Int, CT),
    association: (String, Double),
    price: Double)

/* this should be generated by the annotation
   object Config {

     implicit def hostReader[A1]: Reader[Config[A1], String] =
       Reader(c => c.host._1)

     implicit def portReader[A1]: Reader[Config[A1], Int] =
       Reader(c => c.port._1)

     implicit def associationReader[A1]: Reader[Config[A1], (String, Double)] =
       Reader(c => c.association)

     implicit def priceReader[A1]: Reader[Config[A1], Double] =
       Reader(c => c.price)
   }
*/

  val hostReader: cats.data.Reader[Config[Prod], String] =
    implicitly[cats.data.Reader[Config[Prod], String]]

  val portReader: cats.data.Reader[Config[Prod], Int] =
    implicitly[cats.data.Reader[Config[Prod], Int]]

  val associationReader: cats.data.Reader[Config[Prod], (String, Double)] =
    implicitly[cats.data.Reader[Config[Prod], (String, Double)]]

  val priceReader: cats.data.Reader[Config[Prod], Double] =
    implicitly[cats.data.Reader[Config[Prod], Double]]

}
