/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.guild.api.json.fields.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.zalando.guild.api.json.fields.jackson.ContextProvider;
import org.zalando.guild.api.json.fields.java.model.FieldPredicate;

public final class JsonFieldsFilterProvider
extends SimpleFilterProvider {
    public static final String FILTER_ID = FieldPredicatePropertyFilter.class.getName();
    private static final long serialVersionUID = -1263420090088201679L;
    private final Supplier<FieldPredicate> predicateSupplier;
    private final ContextProvider contextProvider;
    private static final PropertyFilter INCLUDE_ALL = new SimpleBeanPropertyFilter(){

        protected boolean include(BeanPropertyWriter writer) {
            return true;
        }

        protected boolean include(PropertyWriter writer) {
            return true;
        }

        public String toString() {
            return "JsonFieldsFilterProvider.INCLUDE_ALL";
        }
    };

    public JsonFieldsFilterProvider(@Nonnull Supplier<FieldPredicate> predicateSupplier, @Nonnull ContextProvider contextProvider) {
        this.predicateSupplier = (Supplier)Preconditions.checkNotNull(predicateSupplier, (Object)"PredicateProvider required");
        this.contextProvider = (ContextProvider)Preconditions.checkNotNull((Object)contextProvider, (Object)"ContextProvider required");
        super.setFailOnUnknownId(false);
    }

    public SimpleFilterProvider setFailOnUnknownId(boolean state) {
        throw new UnsupportedOperationException();
    }

    public boolean willFailOnUnknownId() {
        return false;
    }

    public PropertyFilter findPropertyFilter(Object filterId, Object valueToFilter) {
        PropertyFilter propertyFilter = super.findPropertyFilter(filterId, valueToFilter);
        return new FieldPredicatePropertyFilter(propertyFilter == null ? INCLUDE_ALL : propertyFilter);
    }

    private class FieldPredicatePropertyFilter
    implements PropertyFilter {
        private final PropertyFilter delegate;

        public FieldPredicatePropertyFilter(PropertyFilter delegate) {
            this.delegate = delegate;
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
            String name = writer.getName();
            FieldPredicate fieldPredicate = (FieldPredicate)JsonFieldsFilterProvider.this.predicateSupplier.get();
            if (fieldPredicate.apply(this.qualifiedPath(name))) {
                JsonFieldsFilterProvider.this.contextProvider.pushContext(name);
                this.delegate.serializeAsField(pojo, jgen, prov, writer);
                JsonFieldsFilterProvider.this.contextProvider.popContext();
            }
        }

        private List<String> qualifiedPath(String path) {
            List<String> context = JsonFieldsFilterProvider.this.contextProvider.getContext();
            ArrayList<String> paths = new ArrayList<String>(context.size() + 1);
            paths.addAll(context);
            paths.add(path);
            return paths;
        }

        public void serializeAsElement(Object elementValue, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
            this.delegate.serializeAsElement(elementValue, jgen, prov, writer);
        }

        public void depositSchemaProperty(PropertyWriter writer, ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
            this.delegate.depositSchemaProperty(writer, propertiesNode, provider);
        }

        public void depositSchemaProperty(PropertyWriter writer, JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
            this.delegate.depositSchemaProperty(writer, objectVisitor, provider);
        }
    }
}

