/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.guild.api.json.fields.jackson.servlet;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.zalando.guild.api.json.fields.java.model.FieldPredicate;

public class HttpRequestFieldPredicateProvider
implements Supplier<FieldPredicate> {
    private final Supplier<HttpServletRequest> requestSupplier;
    private final Function<HttpServletRequest, FieldPredicate> predicateFunction;

    private HttpRequestFieldPredicateProvider(Supplier<HttpServletRequest> requestSupplier, Function<HttpServletRequest, FieldPredicate> predicateFunction) {
        this.requestSupplier = requestSupplier;
        this.predicateFunction = predicateFunction;
    }

    @Nonnull
    public static HttpRequestFieldPredicateProvider httpRequestFieldPredicateProvider(@Nonnull Supplier<HttpServletRequest> requestSupplier, @Nonnull Function<HttpServletRequest, FieldPredicate> predicateFunction) {
        Preconditions.checkNotNull(requestSupplier, (Object)"RequestSupplier required");
        Preconditions.checkNotNull(predicateFunction, (Object)"PredicateFunction required");
        return new HttpRequestFieldPredicateProvider(requestSupplier, predicateFunction);
    }

    @Nonnull
    public FieldPredicate get() {
        return (FieldPredicate)this.predicateFunction.apply(this.requestSupplier.get());
    }
}

