/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.guild.api.json.fields.jackson.servlet;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.zalando.guild.api.json.fields.java.expression.ParserFramework;
import org.zalando.guild.api.json.fields.java.model.FieldPredicate;
import org.zalando.guild.api.json.fields.java.model.FieldPredicates;

public class ParamBasedPredicateFunction
implements Function<HttpServletRequest, FieldPredicate> {
    private static final String DEFAULT_PARAM_NAME = "fields";
    private final String paramName;

    protected ParamBasedPredicateFunction(String paramName) {
        this.paramName = paramName;
    }

    protected ParamBasedPredicateFunction() {
        this(DEFAULT_PARAM_NAME);
    }

    @Nonnull
    public static ParamBasedPredicateFunction paramBasedPredicateFunctionWithDefaultName() {
        return new ParamBasedPredicateFunction();
    }

    @Nonnull
    public static ParamBasedPredicateFunction paramBasedPredicateFunctionWithCustomName(@Nonnull String paramName) {
        Preconditions.checkNotNull((Object)paramName, (Object)"ParamName required");
        return new ParamBasedPredicateFunction(paramName);
    }

    @Nonnull
    public final FieldPredicate apply(@Nonnull HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request required");
        String parameterValue = request.getParameter(this.paramName);
        if (parameterValue != null) {
            try {
                return ParserFramework.parseFieldsExpressionOrFail((String)parameterValue);
            }
            catch (IllegalArgumentException e) {
                return this.handleExpressionFailure(parameterValue, e);
            }
        }
        return FieldPredicates.alwaysTrue();
    }

    @Nonnull
    protected FieldPredicate handleExpressionFailure(@Nonnull String expression, @Nonnull IllegalArgumentException e) {
        return FieldPredicates.alwaysFalse();
    }
}

