/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.guild.api.json.fields.jackson.servlet;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public final class ThreadLocalRequestProvider
implements Supplier<HttpServletRequest> {
    private static final ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();

    @Nonnull
    public HttpServletRequest get() {
        return REQUEST.get();
    }

    public static void assignRequest(@Nonnull HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request required");
        REQUEST.set(request);
    }

    public static void removeRequest() {
        REQUEST.remove();
    }

    private ThreadLocalRequestProvider() {
    }

    @Nonnull
    public ThreadLocalRequestProvider getInstance() {
        return Holder.INSTANCE;
    }

    static final class Holder {
        public static final ThreadLocalRequestProvider INSTANCE = new ThreadLocalRequestProvider();

        private Holder() {
        }
    }
}

