/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.guild.api.json.fields.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import org.zalando.guild.api.json.fields.jackson.ContextProvider;
import org.zalando.guild.api.json.fields.jackson.JsonFieldsAnnotationIntrospector;
import org.zalando.guild.api.json.fields.jackson.JsonFieldsFilterProvider;
import org.zalando.guild.api.json.fields.jackson.generated.PackageVersion;
import org.zalando.guild.api.json.fields.java.model.FieldPredicate;

public class JsonFieldsModule
extends SimpleModule {
    private static final long serialVersionUID = 7598419837008787123L;
    private JsonFieldsAnnotationIntrospector jsonFieldsAnnotationIntrospector;
    private final Supplier<FieldPredicate> predicateSupplier;
    private final ContextProvider contextProvider;

    public static JsonFieldsModule createJsonFieldsModuleWithCustomIntrospector(@Nonnull Supplier<FieldPredicate> predicateSupplier, @Nonnull ContextProvider contextProvider, @Nonnull JsonFieldsAnnotationIntrospector introspector) {
        Preconditions.checkNotNull(predicateSupplier, (Object)"PredicateSupplier required");
        Preconditions.checkNotNull((Object)contextProvider, (Object)"ContextProvider required");
        Preconditions.checkNotNull((Object)((Object)introspector), (Object)"Introspector required");
        return new JsonFieldsModule(predicateSupplier, contextProvider, introspector);
    }

    public static JsonFieldsModule createJsonFieldsModule(@Nonnull Supplier<FieldPredicate> predicateSupplier, @Nonnull ContextProvider contextProvider) {
        Preconditions.checkNotNull(predicateSupplier, (Object)"PredicateSupplier required");
        Preconditions.checkNotNull((Object)contextProvider, (Object)"ContextProvider required");
        return new JsonFieldsModule(predicateSupplier, contextProvider);
    }

    public void setupModule(Module.SetupContext context) {
        context.insertAnnotationIntrospector((AnnotationIntrospector)this.jsonFieldsAnnotationIntrospector);
        ObjectMapper objectMapper = (ObjectMapper)context.getOwner();
        JsonFieldsFilterProvider filterProvider = new JsonFieldsFilterProvider(this.predicateSupplier, this.contextProvider);
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
    }

    private JsonFieldsModule(@Nonnull Supplier<FieldPredicate> predicateSupplier, @Nonnull ContextProvider contextProvider, @Nonnull JsonFieldsAnnotationIntrospector introspector) {
        super(PackageVersion.VERSION);
        this.predicateSupplier = predicateSupplier;
        this.contextProvider = contextProvider;
        this.jsonFieldsAnnotationIntrospector = introspector;
    }

    private JsonFieldsModule(@Nonnull Supplier<FieldPredicate> predicateSupplier, @Nonnull ContextProvider contextProvider) {
        this(predicateSupplier, contextProvider, new JsonFieldsAnnotationIntrospector());
    }
}

