/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.guild.api.json.fields.jackson;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.zalando.guild.api.json.fields.jackson.ContextProvider;

public final class ThreadLocalContextProvider
implements ContextProvider {
    private static final ThreadLocal<LinkedList<String>> STORE = new ThreadLocal<LinkedList<String>>(){

        @Override
        protected LinkedList<String> initialValue() {
            return new LinkedList<String>();
        }
    };

    private ThreadLocalContextProvider() {
    }

    public static ThreadLocalContextProvider getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    @Nonnull
    public List<String> getContext() {
        return Collections.unmodifiableList((List)STORE.get());
    }

    @Override
    public void pushContext(@Nonnull String context) {
        STORE.get().addLast(context);
    }

    @Override
    public void popContext() {
        STORE.get().removeLast();
    }

    @Override
    public void clear() {
        STORE.get().clear();
    }

    static final class Holder {
        public static final ThreadLocalContextProvider INSTANCE = new ThreadLocalContextProvider();

        private Holder() {
        }
    }
}

