/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.jackson.module.unknownproperty;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import org.slf4j.Logger;
import org.slf4j.event.Level;

final class UnknownPropertyDeserializationProblemHandler
extends DeserializationProblemHandler {
    private final Logger logger;
    private final Level logLevel;
    private final String format;

    UnknownPropertyDeserializationProblemHandler(Logger logger, Level logLevel, String format) {
        this.logger = logger;
        this.logLevel = logLevel;
        this.format = format;
    }

    public boolean handleUnknownProperty(DeserializationContext context, JsonParser parser, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) {
        Class<?> type = beanOrClass.getClass();
        switch (this.logLevel) {
            case DEBUG: {
                this.logger.debug(this.format, type, (Object)propertyName);
                break;
            }
            case INFO: {
                this.logger.info(this.format, type, (Object)propertyName);
                break;
            }
            case WARN: {
                this.logger.warn(this.format, type, (Object)propertyName);
                break;
            }
            case ERROR: {
                this.logger.error(this.format, type, (Object)propertyName);
                break;
            }
            default: {
                this.logger.trace(this.format, type, (Object)propertyName);
            }
        }
        return false;
    }
}

