/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.jackson.module.unknownproperty;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.zalando.jackson.module.unknownproperty.UnknownPropertyDeserializationProblemHandler;

public final class UnknownPropertyModule
extends Module {
    private static final Logger LOG = LoggerFactory.getLogger(UnknownPropertyModule.class);
    private final Logger logger;
    private final Level logLevel;
    private final String format;

    public UnknownPropertyModule() {
        this(LOG);
    }

    public UnknownPropertyModule(Logger logger) {
        this(logger, "Unknown property in {}: {}");
    }

    public UnknownPropertyModule(String format) {
        this(LOG, format);
    }

    public UnknownPropertyModule(Logger logger, String format) {
        this(logger, Level.TRACE, format);
    }

    private UnknownPropertyModule(Logger logger, Level logLevel, String format) {
        this.logger = logger;
        this.logLevel = logLevel;
        this.format = format;
    }

    public UnknownPropertyModule withLogLevel(Level logLevel) {
        return new UnknownPropertyModule(this.logger, logLevel, this.format);
    }

    public String getModuleName() {
        return UnknownPropertyModule.class.getSimpleName();
    }

    public Version version() {
        ClassLoader loader = UnknownPropertyModule.class.getClassLoader();
        return VersionUtil.mavenVersionFor((ClassLoader)loader, (String)"org.zalando", (String)"jackson-module-unknown-property");
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializationProblemHandler((DeserializationProblemHandler)new UnknownPropertyDeserializationProblemHandler(this.logger, this.logLevel, this.format));
    }
}

