/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.kanadi.api;

import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.CensoredRawHeader;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.stream.Materializer;
import com.typesafe.scalalogging.CanLog;
import de.heikoseeberger.akkahttpcirce.ErrorAccumulatingCirceSupport$;
import io.circe.DecodingFailure;
import io.circe.Json;
import java.util.UUID;
import org.mdedetrich.webmodels.Problem;
import org.mdedetrich.webmodels.circe$;
import org.slf4j.MDC;
import org.zalando.kanadi.models.BasicServerError;
import org.zalando.kanadi.models.BasicServerError$;
import org.zalando.kanadi.models.GeneralError;
import org.zalando.kanadi.models.HttpConfig;
import org.zalando.kanadi.models.OtherError;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static final package$ MODULE$;
    private final String xNakadiStreamIdHeader;
    private final CanLog<String> canLogFlowId;
    private volatile byte bitmap$init$0;

    static {
        new package$();
    }

    public String xNakadiStreamIdHeader() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.xNakadiStreamIdHeader;
        }
        throw new UninitializedFieldError("Uninitialized field: package.scala: 20");
    }

    public String randomFlowId() {
        return UUID.randomUUID().toString();
    }

    public HttpHeader toHeader(String oAuth2Token, HttpConfig kanadiHttpConfig) {
        return kanadiHttpConfig.censorOAuth2Token() ? new CensoredRawHeader("Authorization", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bearer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oAuth2Token})), "Bearer <secret>") : new RawHeader("Authorization", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bearer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oAuth2Token})));
    }

    public HttpRequest stripAuthToken(HttpRequest request, HttpConfig kanadiHttpConfig) {
        scala.collection.immutable.Seq headers = (scala.collection.immutable.Seq)request.headers().map((Function1)new Serializable(kanadiHttpConfig){
            public static final long serialVersionUID = 0L;
            private final HttpConfig kanadiHttpConfig$1;

            public final HttpHeader apply(HttpHeader x0$1) {
                HttpHeader httpHeader;
                Authorization authorization;
                HttpCredentials httpCredentials;
                if (x0$1 instanceof Authorization && (httpCredentials = (authorization = (Authorization)x0$1).credentials()) instanceof OAuth2BearerToken) {
                    OAuth2BearerToken oAuth2BearerToken = (OAuth2BearerToken)httpCredentials;
                    String token = oAuth2BearerToken.token();
                    httpHeader = package$.MODULE$.toHeader(token, this.kanadiHttpConfig$1);
                } else {
                    httpHeader = x0$1;
                }
                return httpHeader;
            }
            {
                this.kanadiHttpConfig$1 = kanadiHttpConfig$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return request.withHeaders(headers);
    }

    public final CanLog<String> canLogFlowId() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.canLogFlowId;
        }
        throw new UninitializedFieldError("Uninitialized field: package.scala: 60");
    }

    public Future<Nothing$> processNotSuccessful(HttpResponse response, Materializer materializer, ExecutionContext executionContext) {
        return Unmarshal$.MODULE$.apply((Object)HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()).withContentType((ContentType)ContentTypes$.MODULE$.application$divjson())).to(ErrorAccumulatingCirceSupport$.MODULE$.jsonUnmarshaller(), executionContext, materializer).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Json json) {
                Either either = json.as(circe$.MODULE$.problemDecoder());
                if (either instanceof Left) {
                    Either either2 = json.as(BasicServerError$.MODULE$.basicServerErrorDecoder());
                    if (either2 instanceof Left) {
                        Left left = (Left)either2;
                        DecodingFailure error = (DecodingFailure)left.a();
                        throw error;
                    }
                    if (either2 instanceof Right) {
                        Right right = (Right)either2;
                        BasicServerError basicServerError = (BasicServerError)right.b();
                        throw new OtherError(basicServerError);
                    }
                    throw new MatchError((Object)either2);
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Problem problem = (Problem)right.b();
                    throw new GeneralError(problem);
                }
                throw new MatchError((Object)either);
            }
        }, executionContext);
    }

    private package$() {
        MODULE$ = this;
        this.xNakadiStreamIdHeader = "X-Nakadi-StreamId";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.canLogFlowId = new CanLog<String>(){

            public String logMessage(String originalMsg, String flowId) {
                MDC.put((String)"flow_id", (String)flowId);
                return originalMsg;
            }

            public void afterLog(String flowId) {
                MDC.remove((String)"flow_id");
            }
            {
                CanLog.class.$init$((CanLog)this);
            }
        };
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

