/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.kanadi.api;

import com.typesafe.scalalogging.CanLog;
import io.circe.Decoder;
import java.io.Serializable;
import java.util.UUID;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.headers.Authorization;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.MaskedRawHeader;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.util.ByteString$;
import org.slf4j.MDC;
import org.zalando.kanadi.models.BasicServerError;
import org.zalando.kanadi.models.BasicServerError$;
import org.zalando.kanadi.models.FlowId;
import org.zalando.kanadi.models.GeneralError;
import org.zalando.kanadi.models.HttpConfig;
import org.zalando.kanadi.models.HttpServiceError;
import org.zalando.kanadi.models.OtherError;
import org.zalando.kanadi.models.Problem;
import org.zalando.kanadi.models.codec.ProblemCodec$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static package$ MODULE$;
    private final String xNakadiStreamIdHeader;
    private final CanLog<FlowId> canLogFlowId;
    private volatile byte bitmap$init$0;

    static {
        new package$();
    }

    public String xNakadiStreamIdHeader() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/gchudnov/Projects/kanadi/src/main/scala/org/zalando/kanadi/api/package.scala: 18");
        }
        return this.xNakadiStreamIdHeader;
    }

    public String randomFlowId() {
        return UUID.randomUUID().toString();
    }

    public HttpHeader toHeader(String authToken, HttpConfig kanadiHttpConfig) {
        if (kanadiHttpConfig.censorAuthToken()) {
            return new MaskedRawHeader("Authorization", new StringBuilder(7).append("Bearer ").append(authToken).toString(), "Bearer <secret>");
        }
        return new RawHeader("Authorization", new StringBuilder(7).append("Bearer ").append(authToken).toString());
    }

    public HttpRequest stripAuthToken(HttpRequest request, HttpConfig kanadiHttpConfig) {
        Seq headers = (Seq)request.headers().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Authorization authorization;
            HttpCredentials httpCredentials;
            HttpHeader httpHeader = x0$1;
            if (httpHeader instanceof Authorization && (httpCredentials = (authorization = (Authorization)httpHeader).credentials()) instanceof OAuth2BearerToken) {
                OAuth2BearerToken oAuth2BearerToken = (OAuth2BearerToken)httpCredentials;
                String token = oAuth2BearerToken.token();
                return MODULE$.toHeader(token, kanadiHttpConfig);
            }
            return httpHeader;
        }, Seq$.MODULE$.canBuildFrom());
        return request.withHeaders(headers);
    }

    public final CanLog<FlowId> canLogFlowId() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/gchudnov/Projects/kanadi/src/main/scala/org/zalando/kanadi/api/package.scala: 59");
        }
        return this.canLogFlowId;
    }

    public Future<Nothing$> processNotSuccessful(HttpRequest request, HttpResponse response, Materializer materializer, ExecutionContext executionContext) {
        return this.unmarshalStringOrProblem((HttpEntity)response.entity(), materializer, executionContext).map((Function1 & Serializable & scala.Serializable)stringOrProblem -> {
            Either either = stringOrProblem;
            if (either instanceof Left) {
                Left left = (Left)either;
                String body = (String)left.value();
                Either either2 = io.circe.parser.package$.MODULE$.parse(body).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.as(BasicServerError$.MODULE$.basicServerErrorDecoder()));
                if (either2 instanceof Left) {
                    throw new HttpServiceError(request, response, (Either<String, Problem>)stringOrProblem);
                }
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    BasicServerError basicServerError = (BasicServerError)right.value();
                    throw new OtherError(basicServerError);
                }
                throw new MatchError((Object)either2);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Problem problem = (Problem)right.value();
                throw new GeneralError(problem, request, response);
            }
            throw new MatchError((Object)either);
        }, executionContext);
    }

    public Option<Problem> maybeStringToProblem(String string) {
        if (string.isEmpty()) {
            return None$.MODULE$;
        }
        return io.circe.parser.package$.MODULE$.decode(string, ProblemCodec$.MODULE$.problemDecoder()).toOption();
    }

    public Future<Either<String, Problem>> unmarshalStringOrProblem(HttpEntity entity, Materializer materializer, ExecutionContext executionContext) {
        return Unmarshal$.MODULE$.apply((Object)entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), executionContext, materializer).recover((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (Unmarshaller.NoContentException$.MODULE$.equals(A1)) {
                    return (B1)"";
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return Unmarshaller.NoContentException$.MODULE$.equals(throwable);
            }
        }, executionContext).map((Function1 & Serializable & scala.Serializable)asString -> {
            Option<Problem> tryDecodeAsProblem = MODULE$.maybeStringToProblem((String)asString);
            return new Tuple2(asString, tryDecodeAsProblem);
        }, executionContext).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                String asString = (String)tuple2._1();
                Option tryDecodeAsProblem = (Option)tuple2._2();
                return tryDecodeAsProblem.toRight((Function0 & Serializable & scala.Serializable)() -> asString);
            }
            throw new MatchError((Object)tuple2);
        }, executionContext);
    }

    public <T> Future<T> unmarshalAs(HttpEntity entity, Decoder<T> evidence$1, Materializer materializer, ExecutionContext executionContext) {
        Future dataF = entity.dataBytes().runFold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$plus$plus(x$4), materializer).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.utf8String(), executionContext);
        return dataF.flatMap((Function1 & Serializable & scala.Serializable)data -> {
            Either errOrDecoder = io.circe.parser.package$.MODULE$.decode(data, evidence$1);
            return Future$.MODULE$.fromTry(errOrDecoder.toTry(Predef$.MODULE$.$conforms()));
        }, executionContext);
    }

    private package$() {
        MODULE$ = this;
        this.xNakadiStreamIdHeader = "X-Nakadi-StreamId";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.canLogFlowId = new CanLog<FlowId>(){

            public Object getContext(Object context) {
                return CanLog.getContext$((CanLog)this, (Object)context);
            }

            public String logMessage(String originalMsg, String flowId) {
                MDC.put((String)"flow_id", (String)flowId);
                return originalMsg;
            }

            public void afterLog(String flowId) {
                MDC.remove((String)"flow_id");
            }
            {
                CanLog.$init$((CanLog)this);
            }
        };
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

