/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.IOException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.jaxrs.Attributes;
import org.zalando.logbook.jaxrs.LocalRequest;
import org.zalando.logbook.jaxrs.RemoteResponse;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
public final class LogbookClientFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private final Logbook logbook;

    public LogbookClientFilter(Logbook logbook) {
        this.logbook = logbook;
    }

    public void filter(ClientRequestContext context) throws IOException {
        LocalRequest request = new LocalRequest(context);
        if (context.hasEntity()) {
            context.setProperty(Attributes.REQUEST, (Object)request);
        } else {
            this.logRequest((arg_0, arg_1) -> ((ClientRequestContext)context).setProperty(arg_0, arg_1), request);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        context.proceed();
        LogbookClientFilter.read(arg_0 -> ((WriterInterceptorContext)context).getProperty(arg_0), Attributes.REQUEST, RawHttpRequest.class).ifPresent((Consumer<RawHttpRequest>)FauxPas.throwingConsumer(request -> this.logRequest((arg_0, arg_1) -> ((WriterInterceptorContext)context).setProperty(arg_0, arg_1), (RawHttpRequest)request)));
    }

    private void logRequest(BiConsumer<String, Correlator> context, RawHttpRequest request) throws IOException {
        this.logbook.write(request).ifPresent(correlator -> context.accept(Attributes.CORRELATOR, (Correlator)correlator));
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) {
        LogbookClientFilter.read(arg_0 -> ((ClientRequestContext)request).getProperty(arg_0), Attributes.CORRELATOR, Correlator.class).ifPresent((Consumer<Correlator>)FauxPas.throwingConsumer(correlator -> correlator.write((RawHttpResponse)new RemoteResponse(response))));
    }

    private static <T> Optional<T> read(Function<String, Object> provider, String name, Class<T> type) {
        return Optional.ofNullable(provider.apply(name)).map(type::cast);
    }
}

