/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.client.ClientRequestContext;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.HttpMessages;
import org.zalando.logbook.jaxrs.TeeOutputStream;

final class LocalRequest
implements HttpRequest {
    private final ClientRequestContext context;
    private TeeOutputStream stream;
    private byte[] body;

    public LocalRequest(ClientRequestContext context) {
        this.context = context;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.context.getMethod();
    }

    public String getScheme() {
        return this.context.getUri().getScheme();
    }

    public String getHost() {
        return this.context.getUri().getHost();
    }

    public Optional<Integer> getPort() {
        return HttpMessages.getPort(this.context.getUri());
    }

    public String getPath() {
        return this.context.getUri().getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.context.getUri().getQuery()).orElse("");
    }

    public Map<String, List<String>> getHeaders() {
        return this.context.getStringHeaders();
    }

    @Nullable
    public String getContentType() {
        return (String)this.context.getStringHeaders().getFirst((Object)"Content-Type");
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpRequest withBody() {
        if (this.stream == null) {
            this.stream = new TeeOutputStream(this.context.getEntityStream());
            this.context.setEntityStream((OutputStream)this.stream);
        }
        return this;
    }

    public HttpRequest withoutBody() {
        if (this.stream != null) {
            this.context.setEntityStream(this.stream.getOriginal());
            this.stream = null;
        }
        return this;
    }

    public byte[] getBody() {
        if (this.body == null) {
            if (this.stream == null) {
                return new byte[0];
            }
            this.body = this.stream.toByteArray();
        }
        return this.body;
    }
}

