/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerResponseContext;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.HttpMessages;
import org.zalando.logbook.jaxrs.TeeOutputStream;

final class LocalResponse
implements HttpResponse {
    private final ContainerResponseContext context;
    private TeeOutputStream stream;
    private byte[] body;

    public LocalResponse(ContainerResponseContext context) {
        this.context = context;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public int getStatus() {
        return this.context.getStatus();
    }

    public Map<String, List<String>> getHeaders() {
        return this.context.getStringHeaders();
    }

    @Nullable
    public String getContentType() {
        return Objects.toString(this.context.getMediaType(), null);
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpResponse withBody() {
        if (this.stream == null) {
            this.stream = new TeeOutputStream(this.context.getEntityStream());
            this.context.setEntityStream((OutputStream)this.stream);
        }
        return this;
    }

    public HttpResponse withoutBody() {
        if (this.stream != null) {
            this.context.setEntityStream(this.stream.getOriginal());
            this.stream = null;
        }
        return this;
    }

    public byte[] getBody() {
        if (this.body == null) {
            if (this.stream == null) {
                return new byte[0];
            }
            this.body = this.stream.toByteArray();
        }
        return this.body;
    }
}

