/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.ByteStreams;
import org.zalando.logbook.jaxrs.HttpMessages;

final class RemoteRequest
implements HttpRequest {
    private final ContainerRequestContext context;
    private byte[] body;

    public RemoteRequest(ContainerRequestContext context) {
        this.context = context;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getRemote() {
        return this.context.getUriInfo().getRequestUri().getAuthority();
    }

    public String getMethod() {
        return this.context.getMethod();
    }

    public String getScheme() {
        return this.context.getUriInfo().getRequestUri().getScheme();
    }

    public String getHost() {
        return this.context.getUriInfo().getRequestUri().getHost();
    }

    public Optional<Integer> getPort() {
        return HttpMessages.getPort(this.context.getUriInfo().getRequestUri());
    }

    public String getPath() {
        return this.context.getUriInfo().getRequestUri().getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.context.getUriInfo().getRequestUri().getQuery()).orElse("");
    }

    public Map<String, List<String>> getHeaders() {
        return this.context.getHeaders();
    }

    @Nullable
    public String getContentType() {
        return (String)this.context.getHeaders().getFirst((Object)"Content-Type");
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpRequest withBody() throws IOException {
        if (this.body == null) {
            this.body = ByteStreams.toByteArray(this.context.getEntityStream());
            this.context.setEntityStream((InputStream)new ByteArrayInputStream(this.body));
        }
        return this;
    }

    public HttpRequest withoutBody() {
        this.body = new byte[0];
        return this;
    }

    public byte[] getBody() {
        return this.body == null ? new byte[]{} : this.body;
    }
}

