/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.client.ClientResponseContext;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.ByteStreams;
import org.zalando.logbook.jaxrs.HttpMessages;

final class RemoteResponse
implements HttpResponse {
    private final ClientResponseContext context;
    private byte[] body;

    public RemoteResponse(ClientResponseContext context) {
        this.context = context;
    }

    public int getStatus() {
        return this.context.getStatus();
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public Map<String, List<String>> getHeaders() {
        return this.context.getHeaders();
    }

    @Nullable
    public String getContentType() {
        return Objects.toString(this.context.getMediaType(), null);
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpResponse withBody() throws IOException {
        if (this.body == null) {
            this.body = ByteStreams.toByteArray(this.context.getEntityStream());
            this.context.setEntityStream((InputStream)new ByteArrayInputStream(this.body));
        }
        return this;
    }

    public HttpResponse withoutBody() {
        this.body = new byte[0];
        return this;
    }

    public byte[] getBody() {
        return this.body == null ? new byte[]{} : this.body;
    }
}

