/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.jaxrs.LocalRequest;
import org.zalando.logbook.jaxrs.RemoteResponse;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
public final class LogbookClientFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private final Logbook logbook;

    public void filter(ClientRequestContext context) throws IOException {
        LocalRequest request = new LocalRequest(context);
        Logbook.RequestWritingStage stage = this.logbook.process((HttpRequest)request);
        if (context.hasEntity()) {
            context.setProperty("request", (Object)request);
            context.setProperty("write-request", (Object)stage);
        } else {
            context.setProperty("process-response", (Object)stage.write());
        }
        request.expose();
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        context.proceed();
        LogbookClientFilter.read(arg_0 -> ((WriterInterceptorContext)context).getProperty(arg_0), "write-request", Logbook.RequestWritingStage.class).ifPresent((Consumer<Logbook.RequestWritingStage>)FauxPas.throwingConsumer(stage -> context.setProperty("process-response", (Object)stage.write())));
    }

    public void filter(ClientRequestContext request, ClientResponseContext context) {
        LogbookClientFilter.read(arg_0 -> ((ClientRequestContext)request).getProperty(arg_0), "process-response", Logbook.ResponseProcessingStage.class).ifPresent((Consumer<Logbook.ResponseProcessingStage>)FauxPas.throwingConsumer(stage -> {
            RemoteResponse response = new RemoteResponse(context);
            Logbook.ResponseWritingStage write = stage.process((HttpResponse)response);
            response.expose();
            write.write();
        }));
    }

    private static <T> Optional<T> read(Function<String, Object> provider, String name, Class<T> type) {
        return Optional.ofNullable(provider.apply(name)).map(type::cast);
    }

    public LogbookClientFilter(Logbook logbook) {
        this.logbook = logbook;
    }
}

