/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.ws.rs.client.ClientRequestContext;
import lombok.Generated;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.HttpMessages;
import org.zalando.logbook.jaxrs.TeeOutputStream;

final class LocalRequest
implements HttpRequest {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ClientRequestContext context;

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.context.getMethod();
    }

    public String getScheme() {
        return this.context.getUri().getScheme();
    }

    public String getHost() {
        return this.context.getUri().getHost();
    }

    public Optional<Integer> getPort() {
        return HttpMessages.getPort(this.context.getUri());
    }

    public String getPath() {
        return this.context.getUri().getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.context.getUri().getQuery()).orElse("");
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.context.getStringHeaders());
    }

    @Nullable
    public String getContentType() {
        return (String)this.context.getStringHeaders().getFirst((Object)"Content-Type");
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void expose() {
        this.state.updateAndGet(state -> state.buffer(this.context));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    public LocalRequest(ClientRequestContext context) {
        this.context = context;
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final TeeOutputStream stream;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.stream.toByteArray();
        }

        @Generated
        public Buffering(TeeOutputStream stream) {
            this.stream = stream;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(ClientRequestContext context) {
            TeeOutputStream stream = new TeeOutputStream(context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            return new Buffering(stream);
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ClientRequestContext context) {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }
}

