/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import jakarta.ws.rs.container.ContainerResponseContext;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.api.HttpHeaders;
import org.zalando.logbook.api.HttpResponse;
import org.zalando.logbook.api.Origin;
import org.zalando.logbook.jaxrs.HttpMessages;
import org.zalando.logbook.jaxrs.TeeOutputStream;

final class LocalResponse
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ContainerResponseContext context;

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public int getStatus() {
        return this.context.getStatus();
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.context.getStringHeaders());
    }

    @Nullable
    public String getContentType() {
        return Objects.toString(this.context.getMediaType(), null);
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpResponse withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void expose() {
        this.state.updateAndGet(state -> state.buffer(this.context));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    public LocalResponse(ContainerResponseContext context) {
        this.context = context;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ContainerResponseContext context) {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final TeeOutputStream stream;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.stream.toByteArray();
        }

        @Generated
        public Buffering(TeeOutputStream stream) {
            this.stream = stream;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(ContainerResponseContext context) {
            TeeOutputStream stream = new TeeOutputStream(context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            return new Buffering(stream);
        }
    }
}

