/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

final class TeeOutputStream
extends OutputStream {
    private final OutputStream original;
    private final ByteArrayOutputStream copy = new ByteArrayOutputStream();

    TeeOutputStream(@Nullable OutputStream original) {
        this.original = original;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.original != null) {
            this.original.write(b);
        }
        this.copy.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.original != null) {
            this.original.write(b, off, len);
        }
        this.copy.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.original != null) {
            this.original.flush();
        }
        this.copy.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.original != null) {
            this.original.close();
        }
        this.copy.close();
    }

    byte[] toByteArray() {
        return this.copy.toByteArray();
    }
}

