/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.jaxrs;

import jakarta.ws.rs.container.ContainerRequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.jaxrs.ByteStreams;
import org.zalando.logbook.jaxrs.HttpMessages;

final class RemoteRequest
implements HttpRequest {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ContainerRequestContext context;

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getRemote() {
        return this.context.getUriInfo().getRequestUri().getAuthority();
    }

    public String getMethod() {
        return this.context.getMethod();
    }

    public String getScheme() {
        return this.context.getUriInfo().getRequestUri().getScheme();
    }

    public String getHost() {
        return this.context.getUriInfo().getRequestUri().getHost();
    }

    public Optional<Integer> getPort() {
        return HttpMessages.getPort(this.context.getUriInfo().getRequestUri());
    }

    public String getPath() {
        return this.context.getUriInfo().getRequestUri().getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.context.getUriInfo().getRequestUri().getQuery()).orElse("");
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.context.getHeaders());
    }

    @Nullable
    public String getContentType() {
        return (String)this.context.getHeaders().getFirst((Object)"Content-Type");
    }

    public Charset getCharset() {
        return HttpMessages.getCharset(this.context.getMediaType());
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void expose() {
        this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.context)));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    public RemoteRequest(ContainerRequestContext context) {
        this.context = context;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ContainerRequestContext context) throws IOException {
            return this;
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static final class Ignoring
    implements State {
        private final Buffering buffering;

        @Override
        public State with() {
            return this.buffering;
        }

        @Generated
        public Ignoring(Buffering buffering) {
            this.buffering = buffering;
        }
    }

    private static final class Buffering
    implements State {
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(byte[] body) {
            this.body = body;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(ContainerRequestContext context) throws IOException {
            byte[] body = ByteStreams.toByteArray(context.getEntityStream());
            context.setEntityStream((InputStream)new ByteArrayInputStream(body));
            return new Buffering(body);
        }
    }
}

