/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HeaderFilters;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.autoconfigure.LogbookAutoConfiguration;
import org.zalando.logbook.autoconfigure.LogbookProperties;

@State(value=Scope.Benchmark)
public class HeaderState {
    private HttpHeaders shopifyResponseHeaders;
    private HttpHeaders postRequestHeaders;
    private HttpHeaders getRequestHeaders;
    private HttpHeaders allResponseHeaders;
    private HttpHeaders allRequestHeaders;
    private HeaderFilter autoconfigurationFilter;
    private HeaderFilter replaceFilter;
    private HeaderFilter replace2xFilter;
    private HeaderFilter removeFilter;
    private HeaderFilter remove2xFilter;

    @Setup(value=Level.Trial)
    public void setUp() throws Exception {
        LogbookProperties properties = new LogbookProperties();
        LogbookAutoConfiguration ac = new LogbookAutoConfiguration(properties);
        this.autoconfigurationFilter = ac.headerFilter();
        this.replaceFilter = HeaderFilters.authorization();
        this.removeFilter = HeaderFilters.removeHeaders((String[])new String[]{"Authorization"});
        this.replace2xFilter = HeaderFilter.merge((HeaderFilter)HeaderFilters.replaceHeaders((String)"Authorization", (String)"XXX"), (HeaderFilter)HeaderFilters.replaceHeaders((String)"Set-Cookie", (String)"XXX"));
        this.remove2xFilter = HeaderFilter.merge((HeaderFilter)HeaderFilters.removeHeaders((String[])new String[]{"Authorization"}), (HeaderFilter)HeaderFilters.removeHeaders((String[])new String[]{"Set-Cookie"}));
        this.postRequestHeaders = this.postRequestHeaders();
        this.getRequestHeaders = HeaderState.getRequestHeaders();
        HttpHeaders responseHeaders = HeaderState.getContentResponseHeaders();
        HttpHeaders istioHeaders = this.defaultIstioHeaders();
        HttpHeaders securityResponseHeaders = HeaderState.defaultSpringSecurityResponseHeaders();
        HttpHeaders defaultOpenIdConnectHeaders = this.defaultOpenIdConnectHeaders();
        this.allRequestHeaders = HttpHeaders.empty();
        this.allRequestHeaders = this.allRequestHeaders.update((Map)this.postRequestHeaders);
        this.allRequestHeaders = this.allRequestHeaders.update((Map)istioHeaders);
        this.allRequestHeaders = this.allRequestHeaders.update((Map)defaultOpenIdConnectHeaders);
        this.allResponseHeaders = HttpHeaders.empty();
        this.allResponseHeaders = this.allResponseHeaders.update((Map)responseHeaders);
        this.allResponseHeaders = this.allResponseHeaders.update((Map)istioHeaders);
        this.allResponseHeaders = this.allResponseHeaders.update((Map)securityResponseHeaders);
        this.shopifyResponseHeaders = this.defaultShopifyResponse();
    }

    protected HttpHeaders postRequestHeaders() {
        return HttpHeaders.empty().update("Accept-Encoding", new String[]{"gzip,deflate"}).update("Accept", new String[]{"application/json"}).update("User-Agent", new String[]{"Apache-HttpClient/x.y.z (Java/1.8.0_xxx)"}).update("Host", new String[]{"https://github.com"}).update("Content-Type", new String[]{"application/json"}).update("Content-Length", new String[]{"256"});
    }

    protected static HttpHeaders getRequestHeaders() {
        return HttpHeaders.empty().update("Accept-Encoding", new String[]{"gzip,deflate"}).update("Accept", new String[]{"application/json"}).update("User-Agent", new String[]{"Apache-HttpClient/x.y.z (Java/1.8.0_xxx)"}).update("Host", new String[]{"https://github.com"});
    }

    protected static HttpHeaders getContentResponseHeaders() {
        return HttpHeaders.empty().update("Content-Type", new String[]{"application/json"}).update("Content-Length", new String[]{"256"}).update("Transfer-Encoding", new String[]{"chunked"}).update("Connection", new String[]{"keep-alive"});
    }

    protected static HttpHeaders defaultSpringSecurityResponseHeaders() {
        return HttpHeaders.empty().update("Cache-Control", new String[]{"no-cache, no-store, max-age=0, must-revalidate"}).update("Pragma", new String[]{"no-cache"}).update("Expires", new String[]{"0"}).update("X-Content-Type-Options", new String[]{"nosniff"}).update("Strict-Transport-Security", new String[]{"max-age=31536000 ; includeSubDomains"}).update("X-Frame-Options", new String[]{"DENY"}).update("X-XSS-Protection", new String[]{"1; mode=block"});
    }

    protected HttpHeaders defaultOpenIdConnectHeaders() {
        return HttpHeaders.empty().update("Authorization", new String[]{UUID.randomUUID().toString()});
    }

    protected HttpHeaders defaultIstioHeaders() {
        return HttpHeaders.empty().update("x-request-id", new String[]{UUID.randomUUID().toString()}).update("x-b3-traceid", new String[]{UUID.randomUUID().toString()}).update("x-b3-spanid", new String[]{UUID.randomUUID().toString()}).update("x-b3-parentspanid", new String[]{"1"}).update("x-b3-flags", new String[]{UUID.randomUUID().toString()}).update("x-ot-span-context", new String[]{UUID.randomUUID().toString()});
    }

    protected HttpHeaders defaultShopifyResponse() {
        return HttpHeaders.empty().update("Content-Type", new String[]{"application/json; charset=utf-8"}).update("Transfer-Encoding", new String[]{"chunked"}).update("Connection", new String[]{"keep-alive"}).update("Set-Cookie", new String[]{"__cfduid=db9ccc357feeef085ffff7ad8b6deee870b15ggg20390; expires=Thu, 21-May-20 10:19:50 GMT; path=/; domain=.xxx.myshopify.com; HttpOnly"}).update("X-Sorting-Hat-PodId", new String[]{"85"}).update("X-Sorting-Hat-ShopId", new String[]{"123456789012"}).update("Vary", new String[]{"Accept-Encoding"}).update("Referrer-Policy", new String[]{"origin-when-cross-origin"}).update("X-Frame-Options", new String[]{"DENY"}).update("X-ShopId", new String[]{"12345678"}).update("X-ShardId", new String[]{"85"}).update("X-Stats-UserId", Collections.emptyList()).update("X-Stats-ApiClientId", new String[]{"123456"}).update("X-Stats-ApiPermissionId", new String[]{"12345678"}).update("HTTP_X_SHOPIFY_SHOP_API_CALL_LIMIT", new String[]{"1/40"}).update("X-Shopify-Shop-Api-Call-Limit", new String[]{"1/40"}).update("X-Shopify-API-Version", new String[]{"2019-04"}).update("Strict-Transport-Security", new String[]{"max-age=7889238"}).update("X-Request-Id", new String[]{"7ce26aaf-24f7-4e4d-b319-xxxxxxxxxxx"}).update("X-Shopify-Stage", new String[]{"production"}).update("Content-Security-Policy", new String[]{"default-src 'self' data: blob: 'unsafe-inline' 'unsafe-eval' https://* shopify-pos://*; block-all-mixed-content; child-src 'self' https://* shopify-pos://*; connect-src 'self' wss://* https://*; frame-ancestors 'none'; img-src 'self' data: blob: https:; script-src https://cdn.shopify.com  https://checkout.shopifycs.com  https://js-agent.newrelic.com  https://bam.nr-data.net  https://dme0ih8comzn4.cloudfront.net  https://api.stripe.com  https://mpsnare.iesnare.com  https://appcenter.intuit.com  https://www.paypal.com  https://maps.googleapis.com  https://www.google-analytics.com  https://v.shopify.com  https://widget.intercom.io  https://js.intercomcdn.com  'self' 'unsafe-inline' 'unsafe-eval'; upgrade-insecure-requests; report-uri /csp-report?source%5Baction%5D=index&source%5Bapp%5D=Shopify&source%5Bcontroller%5D=admin%2Fsettings%2Flocations&source%5Bsection%5D=admin_api&source%5Buuid%5D=7ce26aaf-24f7-4e4d-b319-e3e115da6fc7"}).update("X-Content-Type-Options", new String[]{"nosniff"}).update("X-Download-Options", new String[]{"noopen"}).update("X-Permitted-Cross-Domain-Policies", new String[]{"none"}).update("X-XSS-Protection", new String[]{"1; mode=block; report=/xss-report?source%5Baction%5D=index&source%5Bapp%5D=Shopify&source%5Bcontroller%5D=admin%2Fsettings%2Flocations&source%5Bsection%5D=admin_api&source%5Buuid%5D=7ce26aaf-24f7-4e4d-b319-xxxxxxxxx"}).update("X-Dc", Arrays.asList("ash", "gcp-us-central1")).update("NEL", new String[]{"{\"report_to\":\"network-errors\",\"max_age\":2592000,\"failure_fraction\":0.01,\"success_fraction\":0.0001}\""}).update("Report-To", new String[]{"{\"group\":\"network-errors\",\"max_age\":2592000,\"endpoints\":[{\"url\":\"https://monorail-edge.shopifycloud.com/v1/reports/nel/2019022225/shopify \"}]}"}).update("Expect-CT", Arrays.asList("max-age=604800", "report-uri=\"https://report-uri.cloudflare.com/cdn-cgi/beacon/expect-ct \"")).update("Server", new String[]{"cloudflare"}).update("CF-RAY", new String[]{"4dae0dd6dadddd9572-IAD"});
    }

    public HeaderFilter getAutoconfigurationFilter() {
        return this.autoconfigurationFilter;
    }

    public HeaderFilter getRemoveFilter() {
        return this.removeFilter;
    }

    public HeaderFilter getReplaceFilter() {
        return this.replaceFilter;
    }

    public HeaderFilter getRemove2xFilter() {
        return this.remove2xFilter;
    }

    public HeaderFilter getReplace2xFilter() {
        return this.replace2xFilter;
    }

    public HttpHeaders getGetRequestHeaders() {
        return this.getRequestHeaders;
    }

    public HttpHeaders getPostRequestHeaders() {
        return this.postRequestHeaders;
    }

    public HttpHeaders getShopifyResponseHeaders() {
        return this.shopifyResponseHeaders;
    }

    public HttpHeaders getAllRequestHeaders() {
        return this.allRequestHeaders;
    }

    public HttpHeaders getAllResponseHeaders() {
        return this.allResponseHeaders;
    }
}

