/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Arrays;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogFormatterState;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Sink;
import org.zalando.logbook.autoconfigure.LogbookAutoConfiguration;
import org.zalando.logbook.autoconfigure.LogbookProperties;
import org.zalando.logbook.json.CompactingJsonBodyFilter;
import org.zalando.logbook.logstash.LogstashLogbackSink;

@State(value=Scope.Benchmark)
public class LogbookState {
    private Logbook autoconfigurationLogbook;
    private Logbook autoconfigurationLogstashLogbook;
    private Logbook noopHttpLogFormatterLogbook;

    @Setup(value=Level.Trial)
    public void setUp(HttpLogFormatterState state) throws Exception {
        LogbookProperties properties = new LogbookProperties();
        LogbookAutoConfiguration ac = new LogbookAutoConfiguration(properties);
        this.autoconfigurationLogbook = ac.logbook(ac.requestCondition(), ac.correlationId(), Arrays.asList(ac.headerFilter()), Arrays.asList(ac.pathFilter()), Arrays.asList(ac.queryFilter()), Arrays.asList(ac.bodyFilter()), Arrays.asList(ac.requestFilter()), Arrays.asList(ac.responseFilter()), ac.strategy(), ac.sink(ac.httpFormatter(), ac.writer()));
        LogstashLogbackSink sink = new LogstashLogbackSink((HttpLogFormatter)state.getJsonHttpLogFormatter());
        this.autoconfigurationLogstashLogbook = ac.logbook(ac.requestCondition(), ac.correlationId(), Arrays.asList(ac.headerFilter()), Arrays.asList(ac.pathFilter()), Arrays.asList(ac.queryFilter()), Arrays.asList(ac.bodyFilter(), new CompactingJsonBodyFilter()), Arrays.asList(ac.requestFilter()), Arrays.asList(ac.responseFilter()), ac.strategy(), (Sink)sink);
        LogstashLogbackSink noop = new LogstashLogbackSink((HttpLogFormatter)state.getNoopHttpLogFormatter());
        this.noopHttpLogFormatterLogbook = ac.logbook(ac.requestCondition(), ac.correlationId(), Arrays.asList(ac.headerFilter()), Arrays.asList(ac.pathFilter()), Arrays.asList(ac.queryFilter()), Arrays.asList(ac.bodyFilter(), new CompactingJsonBodyFilter()), Arrays.asList(ac.requestFilter()), Arrays.asList(ac.responseFilter()), ac.strategy(), (Sink)noop);
    }

    public Logbook getAutoconfigurationLogbook() {
        return this.autoconfigurationLogbook;
    }

    public Logbook getAutoconfigurationLogstashLogbook() {
        return this.autoconfigurationLogstashLogbook;
    }

    public Logbook getNoopHttpLogFormatterLogbook() {
        return this.noopHttpLogFormatterLogbook;
    }
}

