/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.time.Duration;
import java.time.Instant;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HeaderState;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.MockHttpRequest;
import org.zalando.logbook.MockHttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.jmh.DefaultCorrelation;
import org.zalando.logbook.jmh.DefaultPrecorrelation;

@State(value=Scope.Benchmark)
public class RequestResponseState {
    protected HttpResponse response;
    protected HttpRequest request;
    private final Instant now = Instant.now();
    protected DefaultCorrelation defaultCorrelation = new DefaultCorrelation("id", this.now, this.now.plusMillis(100L), Duration.ofMillis(100L));
    protected DefaultPrecorrelation defaultPrecorrelation = new DefaultPrecorrelation("id", this.defaultCorrelation);
    protected HttpResponse minimalResponse;
    protected Correlation correlation;
    protected HttpRequest minimalRequest;
    protected Precorrelation precorrelation;

    @Setup(value=Level.Trial)
    public void setUp(HeaderState headerState) throws Exception {
        this.minimalResponse = MockHttpResponse.create().withContentType("application/json").withHeaders(HttpHeaders.of((String)"Content-Type", (String[])new String[]{"application/json"})).withBodyAsString("{\"name\":\"Bob\"}");
        this.minimalRequest = MockHttpRequest.create().withContentType("application/json").withHeaders(HttpHeaders.of((String)"Content-Type", (String[])new String[]{"application/json"})).withBodyAsString("{\"name\":\"Bob\"}");
        this.request = MockHttpRequest.create().withContentType("application/json").withHeaders(headerState.getAllRequestHeaders()).withBodyAsString("{\"name\":\"Bob\"}");
        this.response = MockHttpResponse.create().withContentType("application/json").withHeaders(headerState.getAllResponseHeaders()).withBodyAsString("{\"name\":\"Bob\"}");
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public DefaultCorrelation getDefaultCorrelation() {
        return this.defaultCorrelation;
    }

    public DefaultPrecorrelation getDefaultPrecorrelation() {
        return this.defaultPrecorrelation;
    }

    public HttpRequest getMinimalRequest() {
        return this.minimalRequest;
    }

    public HttpResponse getMinimalResponse() {
        return this.minimalResponse;
    }

    public Correlation getCorrelation() {
        return this.correlation;
    }

    public Precorrelation getPrecorrelation() {
        return this.precorrelation;
    }
}

