/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonCompactor;
import org.zalando.logbook.json.JsonMediaType;

@API(status=API.Status.MAINTAINED)
public final class CompactingJsonBodyFilter
implements BodyFilter {
    private static final Logger log = LoggerFactory.getLogger(CompactingJsonBodyFilter.class);
    private final JsonCompactor compactor;

    public CompactingJsonBodyFilter() {
        this(new ObjectMapper());
    }

    public CompactingJsonBodyFilter(ObjectMapper mapper) {
        this.compactor = new JsonCompactor(mapper);
    }

    public String filter(@Nullable String contentType, String body) {
        return JsonMediaType.JSON.test(contentType) && this.isCompactable(body) ? this.compact(body) : body;
    }

    private boolean isCompactable(String body) {
        return !this.compactor.isCompacted(body);
    }

    private String compact(String body) {
        try {
            return this.compactor.compact(body);
        }
        catch (IOException e) {
            log.trace("Unable to compact body, is it a JSON?. Keep it as-is: `{}`", (Object)e.getMessage());
            return body;
        }
    }
}

