/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonMediaType;

public final class JsonBodyFilters {
    private JsonBodyFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter accessToken() {
        HashSet<String> properties = new HashSet<String>(Arrays.asList("access_token", "refresh_token", "open_id", "id_token"));
        return JsonBodyFilters.replaceJsonStringProperty(properties, "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter replaceJsonStringProperty(Set<String> properties, String replacement) {
        String regex = properties.stream().map(Pattern::quote).collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile("(\"(?:" + regex + ")\"\\s*:\\s*)\"(?:[^\"\\\\]|\\\\.)*\"");
        UnaryOperator delegate = body -> pattern.matcher((CharSequence)body).replaceAll("$1\"" + replacement + "\"");
        return (contentType, body) -> JsonMediaType.JSON.test(contentType) ? (String)delegate.apply(body) : body;
    }
}

