/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonCompactor;
import org.zalando.logbook.json.JsonMediaType;

@API(status=API.Status.EXPERIMENTAL)
public final class PrettyPrintingJsonBodyFilter
implements BodyFilter {
    private static final Logger log = LoggerFactory.getLogger(PrettyPrintingJsonBodyFilter.class);
    private final ObjectMapper mapper;
    private final JsonCompactor compactor;
    private final ObjectWriter writer;

    public PrettyPrintingJsonBodyFilter() {
        this(new ObjectMapper());
    }

    public PrettyPrintingJsonBodyFilter(ObjectMapper mapper) {
        this.mapper = mapper;
        this.compactor = new JsonCompactor(mapper);
        this.writer = mapper.writerWithDefaultPrettyPrinter();
    }

    public String filter(@Nullable String contentType, String body) {
        return JsonMediaType.JSON.test(contentType) && this.isProbablyNotPrettyPrinted(body) ? this.prettyPrint(body) : body;
    }

    private boolean isProbablyNotPrettyPrinted(String body) {
        return this.compactor.isCompacted(body);
    }

    private String prettyPrint(String body) {
        try {
            JsonNode value = this.mapper.readTree(body);
            if (value == null) {
                return body;
            }
            return this.writer.writeValueAsString((Object)value);
        }
        catch (IOException e) {
            log.trace("Unable to pretty print body. Is it JSON?. Keep it as-is: `{}`", (Object)e.getMessage());
            return body;
        }
    }
}

