/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonMediaType;
import org.zalando.logbook.json.StringReplaceJsonCompactor;

public class JacksonJsonFieldBodyFilter
implements BodyFilter {
    private static final Logger log = LoggerFactory.getLogger(JacksonJsonFieldBodyFilter.class);
    private static final StringReplaceJsonCompactor fallbackCompactor = new StringReplaceJsonCompactor();
    private final String replacement;
    private final Set<String> fields;
    private final JsonFactory factory;

    public JacksonJsonFieldBodyFilter(Collection<String> fieldNames, String replacement, ObjectMapper objectMapper) {
        this.fields = new HashSet<String>(fieldNames);
        this.replacement = replacement;
        this.factory = objectMapper.getFactory();
    }

    public JacksonJsonFieldBodyFilter(Collection<String> fieldNames, String replacement) {
        this(fieldNames, replacement, new ObjectMapper());
    }

    public String filter(String contentType, String body) {
        return JsonMediaType.JSON.test(contentType) ? this.filter(body) : body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String filter(String body) {
        try {
            JsonParser parser = this.factory.createParser(body);
            StringWriter writer = new StringWriter(body.length() * 2);
            JsonGenerator generator = this.factory.createGenerator((Writer)writer);
            try {
                JsonToken nextToken;
                while ((nextToken = parser.nextToken()) != null) {
                    generator.copyCurrentEvent(parser);
                    if (nextToken != JsonToken.FIELD_NAME || !this.fields.contains(parser.getCurrentName())) continue;
                    nextToken = parser.nextToken();
                    generator.writeString(this.replacement);
                    if (nextToken.isScalarValue()) continue;
                    parser.skipChildren();
                }
            }
            finally {
                parser.close();
                generator.close();
            }
            return writer.toString();
        }
        catch (Exception e) {
            log.trace("Unable to filter body for fields {}, compacting result. `{}`", this.fields, (Object)e.getMessage());
            return fallbackCompactor.compact(body);
        }
    }
}

