/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonMediaType;

public final class JsonBodyFilters {
    private JsonBodyFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter accessToken() {
        HashSet<String> properties = new HashSet<String>(Arrays.asList("access_token", "refresh_token", "open_id", "id_token"));
        return JsonBodyFilters.replaceJsonStringProperty(properties, "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter replaceJsonStringProperty(Set<String> properties, String replacement) {
        String string = "(?:\"(?:[^\"\\\\]|\\\\.)*\")";
        return JsonBodyFilters.replacePrimitiveJsonProperty(properties, "(?:\"(?:[^\"\\\\]|\\\\.)*\")", "\"" + replacement + "\"");
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonNumberProperty(Set<String> properties, Number replacement) {
        String number = "(?:-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?)";
        return JsonBodyFilters.replacePrimitiveJsonProperty(properties, "(?:-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?)", String.valueOf(replacement));
    }

    private static BodyFilter replacePrimitiveJsonProperty(Set<String> properties, String value, String replacement) {
        String regex = properties.stream().map(Pattern::quote).collect(Collectors.joining("|"));
        String property = "\"(?:" + regex + ")\"";
        Pattern pattern = Pattern.compile("(" + property + "\\s*:\\s*)" + value + "|null");
        UnaryOperator delegate = body -> pattern.matcher((CharSequence)body).replaceAll("$1" + replacement);
        return (contentType, body) -> JsonMediaType.JSON.test(contentType) ? (String)delegate.apply(body) : body;
    }
}

