/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.json.JsonMediaType;

@API(status=API.Status.STABLE)
public final class FastJsonHttpLogFormatter
implements HttpLogFormatter {
    private final JsonFactory factory;

    public FastJsonHttpLogFormatter() {
        this(new ObjectMapper());
    }

    public FastJsonHttpLogFormatter(ObjectMapper mapper) {
        this(mapper.getFactory());
    }

    public String format(Precorrelation precorrelation, HttpRequest request) throws IOException {
        return this.format(precorrelation, request, this::prepare);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void prepare(Precorrelation precorrelation, HttpRequest request, JsonGenerator generator) throws IOException {
        generator.writeStringField("origin", request.getOrigin() == Origin.LOCAL ? "local" : "remote");
        generator.writeStringField("type", "request");
        generator.writeStringField("correlation", precorrelation.getId());
        generator.writeStringField("protocol", request.getProtocolVersion());
        generator.writeStringField("remote", request.getRemote());
        generator.writeStringField("method", request.getMethod());
        generator.writeStringField("uri", this.reconstructUri(request));
        this.writeHeaders((HttpMessage)request, generator);
        this.writeBody((HttpMessage)request, generator);
    }

    public String format(Correlation correlation, HttpResponse response) throws IOException {
        return this.format(correlation, response, this::prepare);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public void prepare(Correlation correlation, HttpResponse response, JsonGenerator generator) throws IOException {
        String correlationId = correlation.getId();
        generator.writeStringField("origin", response.getOrigin() == Origin.LOCAL ? "local" : "remote");
        generator.writeStringField("type", "response");
        generator.writeStringField("correlation", correlationId);
        generator.writeStringField("protocol", response.getProtocolVersion());
        generator.writeNumberField("duration", correlation.getDuration().toMillis());
        generator.writeNumberField("status", response.getStatus());
        this.writeHeaders((HttpMessage)response, generator);
        this.writeBody((HttpMessage)response, generator);
    }

    private <C extends Precorrelation, H extends HttpMessage> String format(C correlation, H message, Formatter<C, H> formatter) throws IOException {
        StringWriter writer = new StringWriter(message.getBody().length + 2048);
        try (JsonGenerator generator = this.factory.createGenerator((Writer)writer);){
            generator.writeStartObject();
            formatter.format(correlation, message, generator);
            generator.writeEndObject();
        }
        return writer.toString();
    }

    private void writeHeaders(HttpMessage message, JsonGenerator generator) throws IOException {
        Map headers = message.getHeaders();
        if (headers.isEmpty()) {
            return;
        }
        generator.writeObjectField("headers", (Object)headers);
    }

    private void writeBody(HttpMessage message, JsonGenerator generator) throws IOException {
        String body = message.getBodyAsString();
        if (body.isEmpty()) {
            return;
        }
        generator.writeFieldName("body");
        String contentType = message.getContentType();
        if (JsonMediaType.JSON.test(contentType)) {
            generator.writeRawValue(body);
        } else {
            generator.writeString(body);
        }
    }

    private String reconstructUri(HttpRequest request) {
        StringBuilder builder = new StringBuilder(256);
        String scheme = request.getScheme();
        builder.append(scheme);
        builder.append("://");
        builder.append(request.getHost());
        this.appendPort(request, builder);
        builder.append(request.getPath());
        this.appendQuery(request, builder);
        return builder.toString();
    }

    private void appendPort(HttpRequest request, StringBuilder builder) {
        request.getPort().ifPresent(port -> {
            String scheme = request.getScheme();
            if (this.isStandardPort(scheme, (int)port)) {
                return;
            }
            builder.append(':').append(port);
        });
    }

    private void appendQuery(HttpRequest request, StringBuilder builder) {
        String query = request.getQuery();
        if (query.isEmpty()) {
            return;
        }
        builder.append('?');
        builder.append(query);
    }

    private boolean isStandardPort(String scheme, int port) {
        return "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443;
    }

    public FastJsonHttpLogFormatter(JsonFactory factory) {
        this.factory = factory;
    }

    @FunctionalInterface
    private static interface Formatter<C extends Precorrelation, H extends HttpMessage> {
        public void format(C var1, H var2, JsonGenerator var3) throws IOException;
    }
}

