/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonMediaType;

public final class JsonBodyFilters {
    private static final String BOOLEAN = "(?:true|false)";
    private static final String NUMBER = "(?:-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?)";
    private static final String STRING = "(?:\"(?:[^\"\\\\]+|\\\\.)*\")";
    private static final String PRIMITIVE = "(?:(?:true|false)|(?:-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?)|(?:\"(?:[^\"\\\\]+|\\\\.)*\"))";

    private JsonBodyFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter accessToken() {
        HashSet<String> properties = new HashSet<String>(Arrays.asList("access_token", "refresh_token", "open_id", "id_token"));
        return JsonBodyFilters.replaceJsonStringProperty(properties, "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter replaceJsonStringProperty(Set<String> properties, String replacement) {
        return JsonBodyFilters.replaceJsonStringProperty(properties::contains, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonStringProperty(Predicate<String> predicate, String replacement) {
        return JsonBodyFilters.replace(predicate, STRING, JsonBodyFilters.quote(replacement));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonNumberProperty(Set<String> properties, Number replacement) {
        Predicate<String> predicate = properties::contains;
        return JsonBodyFilters.replaceJsonNumberProperty(predicate, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceJsonNumberProperty(Predicate<String> predicate, Number replacement) {
        return JsonBodyFilters.replace(predicate, NUMBER, String.valueOf(replacement));
    }

    public static BodyFilter replacePrimitiveJsonProperty(Predicate<String> predicate, String replacement) {
        return JsonBodyFilters.replace(predicate, PRIMITIVE, JsonBodyFilters.quote(replacement));
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    private static BodyFilter replace(Predicate<String> predicate, String value, String replacement) {
        Pattern pattern = Pattern.compile("(?<key>\"(?<property>.*?)\"\\s*:\\s*)(" + value + "|null)");
        UnaryOperator delegate = body -> {
            Matcher matcher = pattern.matcher((CharSequence)body);
            StringBuffer result = new StringBuffer(body.length());
            while (matcher.find()) {
                if (predicate.test(matcher.group("property"))) {
                    matcher.appendReplacement(result, "${key}");
                    result.append(replacement);
                    continue;
                }
                matcher.appendReplacement(result, "$0");
            }
            matcher.appendTail(result);
            return result.toString();
        };
        return (contentType, body) -> JsonMediaType.JSON.test(contentType) ? (String)delegate.apply(body) : body;
    }
}

