/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.client;

import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.common.State;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/zalando/logbook/client/ClientRequest;", "Lorg/zalando/logbook/HttpRequest;", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "<init>", "(Lio/ktor/client/request/HttpRequestBuilder;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/zalando/logbook/common/State;", "getProtocolVersion", "", "getOrigin", "Lorg/zalando/logbook/Origin;", "getHeaders", "Lorg/zalando/logbook/HttpHeaders;", "getContentType", "getCharset", "Ljava/nio/charset/Charset;", "getRemote", "getMethod", "getScheme", "getHost", "getPort", "Ljava/util/Optional;", "", "getPath", "getQuery", "withBody", "withoutBody", "getBody", "", "buffer", "bytes", "buffer$logbook_ktor_client", "shouldBuffer", "", "shouldBuffer$logbook_ktor_client", "logbook-ktor-client"})
@SourceDebugExtension(value={"SMAP\nClientRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientRequest.kt\norg/zalando/logbook/client/ClientRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class ClientRequest
implements HttpRequest {
    @NotNull
    private final HttpRequestBuilder request;
    @NotNull
    private final AtomicReference<State> state;

    public ClientRequest(@NotNull HttpRequestBuilder request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.state = new AtomicReference<State.Unbuffered>(new State.Unbuffered());
    }

    @NotNull
    public String getProtocolVersion() {
        return HttpProtocolVersion.Companion.getHTTP_1_1().toString();
    }

    @NotNull
    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    @NotNull
    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders;
        HttpHeaders it = httpHeaders = HttpHeaders.of((Map)StringValuesKt.toMap((StringValues)((StringValues)this.request.getHeaders().build())));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (!((Map)it).containsKey("Content-Type") && this.request.getBody() instanceof OutgoingContent) {
            String[] stringArray = new String[1];
            Object object = this.request.getBody();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.ktor.http.content.OutgoingContent");
            ContentType contentType = ((OutgoingContent)object).getContentType();
            stringArray[0] = contentType != null ? contentType.toString() : null;
            HttpHeaders httpHeaders2 = it.update("Content-Type", stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders2, (String)"update(...)");
            return httpHeaders2;
        }
        HttpHeaders httpHeaders3 = httpHeaders;
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders3, (String)"also(...)");
        return httpHeaders3;
    }

    @Nullable
    public String getContentType() {
        String string;
        ContentType contentType;
        Object object = HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)this.request));
        if (object == null) {
            Object object2 = this.request.getBody();
            OutgoingContent outgoingContent = object2 instanceof OutgoingContent ? (OutgoingContent)object2 : null;
            object = outgoingContent != null ? outgoingContent.getContentType() : null;
        }
        if ((contentType = object) != null) {
            ContentType it = contentType;
            boolean bl = false;
            string = StringsKt.substringBefore$default((String)it.toString(), (String)";", null, (int)2, null);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = HttpMessagePropertiesKt.charset((HttpMessageBuilder)((HttpMessageBuilder)this.request));
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        return charset;
    }

    @NotNull
    public String getRemote() {
        return "localhost";
    }

    @NotNull
    public String getMethod() {
        return this.request.getMethod().getValue();
    }

    @NotNull
    public String getScheme() {
        return this.request.getUrl().getProtocol().getName();
    }

    @NotNull
    public String getHost() {
        return UtilsKt.getHost((HttpRequestBuilder)this.request);
    }

    @NotNull
    public Optional<Integer> getPort() {
        Optional<Integer> optional = Optional.of(UtilsKt.getPort((HttpRequestBuilder)this.request));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public String getPath() {
        return URLBuilderKt.getEncodedPath((URLBuilder)this.request.getUrl());
    }

    @NotNull
    public String getQuery() {
        return StringsKt.substringAfter((String)this.request.getUrl().buildString(), (String)"?", (String)"");
    }

    @NotNull
    public HttpRequest withBody() {
        ClientRequest clientRequest;
        ClientRequest $this$withBody_u24lambda_u243 = clientRequest = this;
        boolean bl = false;
        $this$withBody_u24lambda_u243.state.updateAndGet(ClientRequest::withBody$lambda$3$lambda$2);
        return clientRequest;
    }

    @NotNull
    public HttpRequest withoutBody() {
        ClientRequest clientRequest;
        ClientRequest $this$withoutBody_u24lambda_u245 = clientRequest = this;
        boolean bl = false;
        $this$withoutBody_u24lambda_u245.state.updateAndGet(ClientRequest::withoutBody$lambda$5$lambda$4);
        return clientRequest;
    }

    @NotNull
    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @NotNull
    public final State buffer$logbook_ktor_client(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        State state = this.state.updateAndGet(arg_0 -> ClientRequest.buffer$lambda$6(bytes, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"updateAndGet(...)");
        return state;
    }

    public final boolean shouldBuffer$logbook_ktor_client() {
        return this.state.get() instanceof State.Offering;
    }

    private static final State withBody$lambda$3$lambda$2(State it) {
        return it.with();
    }

    private static final State withoutBody$lambda$5$lambda$4(State it) {
        return it.without();
    }

    private static final State buffer$lambda$6(byte[] $bytes, State it) {
        return it.buffer($bytes);
    }
}

