/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.client;

import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.common.State;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0001H\u0016J\b\u0010#\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/zalando/logbook/client/ClientRequest;", "Lorg/zalando/logbook/HttpRequest;", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "(Lio/ktor/client/request/HttpRequestBuilder;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/zalando/logbook/common/State;", "buffer", "bytes", "", "buffer$logbook_ktor_client", "getBody", "getCharset", "Ljava/nio/charset/Charset;", "getContentType", "", "getHeaders", "Lorg/zalando/logbook/HttpHeaders;", "getHost", "getMethod", "getOrigin", "Lorg/zalando/logbook/Origin;", "getPath", "getPort", "Ljava/util/Optional;", "", "getProtocolVersion", "getQuery", "getRemote", "getScheme", "shouldBuffer", "", "shouldBuffer$logbook_ktor_client", "withBody", "withoutBody", "logbook-ktor-client"})
@SourceDebugExtension(value={"SMAP\nClientRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientRequest.kt\norg/zalando/logbook/client/ClientRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ClientRequest
implements HttpRequest {
    @NotNull
    private final HttpRequestBuilder request;
    @NotNull
    private final AtomicReference<State> state;

    public ClientRequest(@NotNull HttpRequestBuilder request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.state = new AtomicReference<State.Unbuffered>(State.Unbuffered.INSTANCE);
    }

    @NotNull
    public String getProtocolVersion() {
        return HttpProtocolVersion.Companion.getHTTP_1_1().toString();
    }

    @NotNull
    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    @NotNull
    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = HttpHeaders.of((Map)StringValuesKt.toMap((StringValues)((StringValues)this.request.getHeaders().build())));
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"of(...)");
        return httpHeaders;
    }

    @Nullable
    public String getContentType() {
        String string;
        ContentType contentType = HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)this.request));
        if (contentType != null) {
            ContentType it = contentType;
            boolean bl = false;
            string = StringsKt.substringBefore$default((String)it.toString(), (String)";", null, (int)2, null);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = HttpMessagePropertiesKt.charset((HttpMessageBuilder)((HttpMessageBuilder)this.request));
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        return charset;
    }

    @NotNull
    public String getRemote() {
        return "localhost";
    }

    @NotNull
    public String getMethod() {
        return this.request.getMethod().getValue();
    }

    @NotNull
    public String getScheme() {
        return this.request.getUrl().getProtocol().getName();
    }

    @NotNull
    public String getHost() {
        return UtilsKt.getHost((HttpRequestBuilder)this.request);
    }

    @NotNull
    public Optional<Integer> getPort() {
        Optional<Integer> optional = Optional.of(UtilsKt.getPort((HttpRequestBuilder)this.request));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public String getPath() {
        return URLBuilderKt.getEncodedPath((URLBuilder)this.request.getUrl());
    }

    @NotNull
    public String getQuery() {
        return StringsKt.substringAfter((String)this.request.getUrl().buildString(), (String)"?", (String)"");
    }

    @NotNull
    public HttpRequest withBody() {
        ClientRequest clientRequest;
        ClientRequest $this$withBody_u24lambda_u242 = clientRequest = this;
        boolean bl = false;
        $this$withBody_u24lambda_u242.state.updateAndGet(ClientRequest::withBody$lambda$2$lambda$1);
        return clientRequest;
    }

    @NotNull
    public HttpRequest withoutBody() {
        ClientRequest clientRequest;
        ClientRequest $this$withoutBody_u24lambda_u244 = clientRequest = this;
        boolean bl = false;
        $this$withoutBody_u24lambda_u244.state.updateAndGet(ClientRequest::withoutBody$lambda$4$lambda$3);
        return clientRequest;
    }

    @NotNull
    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @NotNull
    public final State buffer$logbook_ktor_client(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        State state = this.state.updateAndGet(arg_0 -> ClientRequest.buffer$lambda$5(bytes, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"updateAndGet(...)");
        return state;
    }

    public final boolean shouldBuffer$logbook_ktor_client() {
        return this.state.get() instanceof State.Offering;
    }

    private static final State withBody$lambda$2$lambda$1(State it) {
        return it.with();
    }

    private static final State withoutBody$lambda$4$lambda$3(State it) {
        return it.without();
    }

    private static final State buffer$lambda$5(byte[] $bytes, State it) {
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        return it.buffer($bytes);
    }
}

