/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.server;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpStatusCode;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.response.ApplicationResponse;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.common.State;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/zalando/logbook/server/ServerResponse;", "Lorg/zalando/logbook/HttpResponse;", "response", "Lio/ktor/response/ApplicationResponse;", "(Lio/ktor/response/ApplicationResponse;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/zalando/logbook/common/State;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "(Lio/ktor/response/ApplicationResponse;)Lio/ktor/http/ContentType;", "buffer", "kotlin.jvm.PlatformType", "bytes", "", "buffer$logbook_ktor_server", "getBody", "getCharset", "Ljava/nio/charset/Charset;", "", "getHeaders", "Lorg/zalando/logbook/HttpHeaders;", "getOrigin", "Lorg/zalando/logbook/Origin;", "getProtocolVersion", "getStatus", "", "shouldBuffer", "", "shouldBuffer$logbook_ktor_server", "withBody", "withoutBody", "logbook-ktor-server"})
public final class ServerResponse
implements HttpResponse {
    @NotNull
    private final ApplicationResponse response;
    @NotNull
    private final AtomicReference<State> state;

    public ServerResponse(@NotNull ApplicationResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.response = response;
        this.state = new AtomicReference<State.Unbuffered>(State.Unbuffered.INSTANCE);
    }

    @NotNull
    public String getProtocolVersion() {
        return ApplicationRequestPropertiesKt.getHttpVersion((ApplicationRequest)this.response.getCall().getRequest());
    }

    @NotNull
    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    @NotNull
    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = HttpHeaders.of((Map)StringValuesKt.toMap((StringValues)((StringValues)this.response.getHeaders().allValues())));
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"of(response.headers.allValues().toMap())");
        return httpHeaders;
    }

    @Nullable
    public String getContentType() {
        String string;
        ContentType contentType = this.getContentType(this.response);
        if (contentType == null) {
            string = null;
        } else {
            ContentType contentType2 = contentType;
            boolean bl = false;
            boolean bl2 = false;
            ContentType it = contentType2;
            boolean bl3 = false;
            string = StringsKt.substringBefore$default((String)it.toString(), (String)";", null, (int)2, null);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        ContentType contentType = this.getContentType(this.response);
        Charset charset = contentType == null ? null : ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)contentType));
        return charset == null ? Charsets.UTF_8 : charset;
    }

    public int getStatus() {
        int n;
        HttpStatusCode httpStatusCode = this.response.status();
        return httpStatusCode == null ? 200 : (n = httpStatusCode.getValue());
    }

    @NotNull
    public HttpResponse withBody() {
        ServerResponse serverResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        ServerResponse $this$withBody_u24lambda_u2d2 = serverResponse;
        boolean bl3 = false;
        $this$withBody_u24lambda_u2d2.state.updateAndGet(ServerResponse::withBody$lambda-2$lambda-1);
        return serverResponse;
    }

    @NotNull
    public HttpResponse withoutBody() {
        ServerResponse serverResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        ServerResponse $this$withoutBody_u24lambda_u2d4 = serverResponse;
        boolean bl3 = false;
        $this$withoutBody_u24lambda_u2d4.state.updateAndGet(ServerResponse::withoutBody$lambda-4$lambda-3);
        return serverResponse;
    }

    @NotNull
    public byte[] getBody() {
        return this.state.get().getBody();
    }

    public final State buffer$logbook_ktor_server(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.state.updateAndGet(arg_0 -> ServerResponse.buffer$lambda-5(bytes, arg_0));
    }

    public final boolean shouldBuffer$logbook_ktor_server() {
        return this.state.get() instanceof State.Offering;
    }

    private final ContentType getContentType(ApplicationResponse $this$contentType) {
        ContentType contentType;
        String string = $this$contentType.getHeaders().get(io.ktor.http.HttpHeaders.INSTANCE.getContentType());
        if (string == null) {
            contentType = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            contentType = ContentType.Companion.parse(it);
        }
        return contentType;
    }

    private static final State withBody$lambda-2$lambda-1(State it) {
        return it.with();
    }

    private static final State withoutBody$lambda-4$lambda-3(State it) {
        return it.without();
    }

    private static final State buffer$lambda-5(byte[] $bytes, State it) {
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        return it.buffer($bytes);
    }
}

