/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.server;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.common.State;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lorg/zalando/logbook/server/ServerRequest;", "Lorg/zalando/logbook/HttpRequest;", "request", "Lio/ktor/request/ApplicationRequest;", "(Lio/ktor/request/ApplicationRequest;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/zalando/logbook/common/State;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "(Lio/ktor/request/ApplicationRequest;)Lio/ktor/http/ContentType;", "buffer", "bytes", "", "buffer$logbook_ktor_server", "getBody", "getCharset", "Ljava/nio/charset/Charset;", "", "getHeaders", "Lorg/zalando/logbook/HttpHeaders;", "getHost", "getMethod", "getOrigin", "Lorg/zalando/logbook/Origin;", "getPath", "getPort", "Ljava/util/Optional;", "", "getProtocolVersion", "getQuery", "getRemote", "getScheme", "shouldBuffer", "", "shouldBuffer$logbook_ktor_server", "withBody", "withoutBody", "logbook-ktor-server"})
public final class ServerRequest
implements HttpRequest {
    @NotNull
    private final ApplicationRequest request;
    @NotNull
    private final AtomicReference<State> state;

    public ServerRequest(@NotNull ApplicationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.state = new AtomicReference<State.Unbuffered>(State.Unbuffered.INSTANCE);
    }

    @NotNull
    public String getProtocolVersion() {
        return ApplicationRequestPropertiesKt.getHttpVersion((ApplicationRequest)this.request);
    }

    @NotNull
    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    @NotNull
    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = HttpHeaders.of((Map)StringValuesKt.toMap((StringValues)((StringValues)this.request.getHeaders())));
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"of(request.headers.toMap())");
        return httpHeaders;
    }

    @Nullable
    public String getContentType() {
        ContentType contentType = this.getContentType(this.request);
        return contentType == null ? null : contentType.getContentType();
    }

    @NotNull
    public Charset getCharset() {
        ContentType contentType = this.getContentType(this.request);
        Charset charset = contentType == null ? null : ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)contentType));
        return charset == null ? Charsets.UTF_8 : charset;
    }

    @NotNull
    public String getRemote() {
        return this.request.getLocal().getRemoteHost();
    }

    @NotNull
    public String getMethod() {
        return ApplicationRequestPropertiesKt.getHttpMethod((ApplicationRequest)this.request).getValue();
    }

    @NotNull
    public String getScheme() {
        return this.request.getLocal().getScheme();
    }

    @NotNull
    public String getHost() {
        return ApplicationRequestPropertiesKt.host((ApplicationRequest)this.request);
    }

    @NotNull
    public Optional<Integer> getPort() {
        Optional<Integer> optional = Optional.of(ApplicationRequestPropertiesKt.port((ApplicationRequest)this.request));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(request.port())");
        return optional;
    }

    @NotNull
    public String getPath() {
        return ApplicationRequestPropertiesKt.path((ApplicationRequest)this.request);
    }

    @NotNull
    public String getQuery() {
        return ApplicationRequestPropertiesKt.queryString((ApplicationRequest)this.request);
    }

    @NotNull
    public HttpRequest withBody() {
        ServerRequest serverRequest = this;
        boolean bl = false;
        boolean bl2 = false;
        ServerRequest $this$withBody_u24lambda_u2d1 = serverRequest;
        boolean bl3 = false;
        $this$withBody_u24lambda_u2d1.state.updateAndGet(ServerRequest::withBody$lambda-1$lambda-0);
        return serverRequest;
    }

    @NotNull
    public HttpRequest withoutBody() {
        ServerRequest serverRequest = this;
        boolean bl = false;
        boolean bl2 = false;
        ServerRequest $this$withoutBody_u24lambda_u2d3 = serverRequest;
        boolean bl3 = false;
        $this$withoutBody_u24lambda_u2d3.state.updateAndGet(ServerRequest::withoutBody$lambda-3$lambda-2);
        return serverRequest;
    }

    @NotNull
    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @NotNull
    public final State buffer$logbook_ktor_server(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        State state = this.state.updateAndGet(arg_0 -> ServerRequest.buffer$lambda-4(bytes, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state.updateAndGet { it.buffer(bytes) }");
        return state;
    }

    public final boolean shouldBuffer$logbook_ktor_server() {
        return this.state.get() instanceof State.Offering;
    }

    private final ContentType getContentType(ApplicationRequest $this$contentType) {
        ContentType contentType;
        String string = $this$contentType.getHeaders().get(io.ktor.http.HttpHeaders.INSTANCE.getContentType());
        if (string == null) {
            contentType = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            contentType = ContentType.Companion.parse(it);
        }
        return contentType;
    }

    private static final State withBody$lambda-1$lambda-0(State it) {
        return it.with();
    }

    private static final State withoutBody$lambda-3$lambda-2(State it) {
        return it.without();
    }

    private static final State buffer$lambda-4(byte[] $bytes, State it) {
        Intrinsics.checkNotNullParameter((Object)$bytes, (String)"$bytes");
        return it.buffer($bytes);
    }
}

