/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.server;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.common.State;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010'\u00a8\u0006("}, d2={"Lorg/zalando/logbook/server/ServerRequest;", "Lorg/zalando/logbook/HttpRequest;", "request", "Lio/ktor/server/request/ApplicationRequest;", "<init>", "(Lio/ktor/server/request/ApplicationRequest;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/zalando/logbook/common/State;", "getProtocolVersion", "", "getOrigin", "Lorg/zalando/logbook/Origin;", "getHeaders", "Lorg/zalando/logbook/HttpHeaders;", "getContentType", "getCharset", "Ljava/nio/charset/Charset;", "getRemote", "getMethod", "getScheme", "getHost", "getPort", "Ljava/util/Optional;", "", "getPath", "getQuery", "withBody", "withoutBody", "getBody", "", "buffer", "bytes", "buffer$logbook_ktor_server", "shouldBuffer", "", "shouldBuffer$logbook_ktor_server", "contentType", "Lio/ktor/http/ContentType;", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/ContentType;", "logbook-ktor-server"})
@SourceDebugExtension(value={"SMAP\nServerRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerRequest.kt\norg/zalando/logbook/server/ServerRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class ServerRequest
implements HttpRequest {
    @NotNull
    private final ApplicationRequest request;
    @NotNull
    private final AtomicReference<State> state;

    public ServerRequest(@NotNull ApplicationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.state = new AtomicReference<State.Unbuffered>(new State.Unbuffered());
    }

    @NotNull
    public String getProtocolVersion() {
        return ApplicationRequestPropertiesKt.getHttpVersion((ApplicationRequest)this.request);
    }

    @NotNull
    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    @NotNull
    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = HttpHeaders.of((Map)StringValuesKt.toMap((StringValues)((StringValues)this.request.getHeaders())));
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"of(...)");
        return httpHeaders;
    }

    @Nullable
    public String getContentType() {
        ContentType contentType = this.getContentType(this.request);
        return contentType != null ? contentType.toString() : null;
    }

    @NotNull
    public Charset getCharset() {
        Object object = this.getContentType(this.request);
        if (object == null || (object = ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)object))) == null) {
            object = Charsets.UTF_8;
        }
        return object;
    }

    @NotNull
    public String getRemote() {
        return this.request.getLocal().getRemoteHost();
    }

    @NotNull
    public String getMethod() {
        return ApplicationRequestPropertiesKt.getHttpMethod((ApplicationRequest)this.request).getValue();
    }

    @NotNull
    public String getScheme() {
        return this.request.getLocal().getScheme();
    }

    @NotNull
    public String getHost() {
        return ApplicationRequestPropertiesKt.host((ApplicationRequest)this.request);
    }

    @NotNull
    public Optional<Integer> getPort() {
        Optional<Integer> optional = Optional.of(ApplicationRequestPropertiesKt.port((ApplicationRequest)this.request));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public String getPath() {
        return ApplicationRequestPropertiesKt.path((ApplicationRequest)this.request);
    }

    @NotNull
    public String getQuery() {
        return ApplicationRequestPropertiesKt.queryString((ApplicationRequest)this.request);
    }

    @NotNull
    public HttpRequest withBody() {
        ServerRequest serverRequest;
        ServerRequest $this$withBody_u24lambda_u241 = serverRequest = this;
        boolean bl = false;
        $this$withBody_u24lambda_u241.state.updateAndGet(ServerRequest::withBody$lambda$1$lambda$0);
        return serverRequest;
    }

    @NotNull
    public HttpRequest withoutBody() {
        ServerRequest serverRequest;
        ServerRequest $this$withoutBody_u24lambda_u243 = serverRequest = this;
        boolean bl = false;
        $this$withoutBody_u24lambda_u243.state.updateAndGet(ServerRequest::withoutBody$lambda$3$lambda$2);
        return serverRequest;
    }

    @NotNull
    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @NotNull
    public final State buffer$logbook_ktor_server(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        State state = this.state.updateAndGet(arg_0 -> ServerRequest.buffer$lambda$4(bytes, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"updateAndGet(...)");
        return state;
    }

    public final boolean shouldBuffer$logbook_ktor_server() {
        return this.state.get() instanceof State.Offering;
    }

    private final ContentType getContentType(ApplicationRequest $this$contentType) {
        ContentType contentType;
        String string = $this$contentType.getHeaders().get(io.ktor.http.HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType = ContentType.Companion.parse(it);
        } else {
            contentType = null;
        }
        return contentType;
    }

    private static final State withBody$lambda$1$lambda$0(State it) {
        return it.with();
    }

    private static final State withoutBody$lambda$3$lambda$2(State it) {
        return it.without();
    }

    private static final State buffer$lambda$4(byte[] $bytes, State it) {
        return it.buffer($bytes);
    }
}

