/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.okhttp;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;

final class LocalRequest
implements HttpRequest {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final Request request;

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.method();
    }

    public String getScheme() {
        return this.request.url().scheme();
    }

    public String getHost() {
        return this.request.url().host();
    }

    public Optional<Integer> getPort() {
        int defaultPort;
        int port = this.request.url().port();
        return port == (defaultPort = HttpUrl.defaultPort((String)this.request.url().scheme())) ? Optional.empty() : Optional.of(port);
    }

    public String getPath() {
        return this.request.url().encodedPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.request.url().query()).orElse("");
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.request.headers().toMultimap());
    }

    public String getContentType() {
        return this.contentType().map(MediaType::toString).orElse("");
    }

    public Charset getCharset() {
        return this.contentType().map(MediaType::charset).orElse(StandardCharsets.UTF_8);
    }

    private Optional<MediaType> contentType() {
        return Optional.ofNullable(this.request.body()).map(RequestBody::contentType);
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    Request toRequest() {
        return this.buffer().getRequest();
    }

    public byte[] getBody() {
        return this.buffer().getBody();
    }

    private State buffer() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(State::buffer));
    }

    @Generated
    public LocalRequest(Request request) {
        this.request = request;
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer() throws IOException {
            return this;
        }

        public Request getRequest();

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private final class Unbuffered
    extends AbstractState {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private final class Passing
    extends AbstractState {
        private Passing() {
        }
    }

    private static final class Ignoring
    implements State {
        private final Request request;
        private final byte[] body;

        @Override
        public State with() {
            return new Buffering(this.request, this.body);
        }

        @Generated
        public Ignoring(Request request, byte[] body) {
            this.request = request;
            this.body = body;
        }

        @Override
        @Generated
        public Request getRequest() {
            return this.request;
        }
    }

    private static final class Buffering
    implements State {
        private final Request request;
        private final byte[] body;

        @Override
        public State without() {
            return new Ignoring(this.request, this.body);
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }

        @Generated
        public Buffering(Request request, byte[] body) {
            this.request = request;
            this.body = body;
        }

        @Override
        @Generated
        public Request getRequest() {
            return this.request;
        }
    }

    private final class Offering
    extends AbstractState {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer() throws IOException {
            RequestBody entity = LocalRequest.this.request.body();
            if (entity == null) {
                return new Passing();
            }
            Buffer buffer = new Buffer();
            entity.writeTo((BufferedSink)buffer);
            byte[] body = buffer.readByteArray();
            Request copy = LocalRequest.this.request.newBuilder().method(LocalRequest.this.request.method(), RequestBody.create((byte[])body, (MediaType)entity.contentType())).build();
            return new Buffering(copy, body);
        }
    }

    private abstract class AbstractState
    implements State {
        @Override
        public Request getRequest() {
            return LocalRequest.this.request;
        }

        @Generated
        public AbstractState() {
        }
    }
}

